/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.config;

import java.util.function.Supplier;
import kd.bos.algo.config.ConfigurationItem;
import kd.bos.util.ConfigurationUtil;

public class MutableConfigurationItem<T>
extends ConfigurationItem<T> {
    private final Supplier<T> defaultValueSupplier;

    public MutableConfigurationItem(String key, T defaultValue, String description) {
        super(key, description);
        this.defaultValueSupplier = () -> defaultValue;
    }

    public MutableConfigurationItem(String key, Supplier<T> defaultValueSupplier, String description) {
        super(key, description);
        this.defaultValueSupplier = defaultValueSupplier;
    }

    @Override
    public int getInt() {
        Integer value = ConfigurationUtil.getInteger((String)this.key);
        return value == null ? (Integer)this.defaultValueSupplier.get() : value;
    }

    @Override
    public long getLong() {
        Long value = ConfigurationUtil.getLong((String)this.key);
        return value == null ? (Long)this.defaultValueSupplier.get() : value;
    }

    @Override
    public String getString() {
        String value = ConfigurationUtil.getString((String)this.key);
        return value == null ? (String)this.defaultValueSupplier.get() : value;
    }

    @Override
    public boolean getBoolean() {
        Boolean value = ConfigurationUtil.getBoolean((String)this.key);
        return value == null ? (Boolean)this.defaultValueSupplier.get() : value;
    }
}

