/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Locale;
import kd.bos.algo.AlgoException;

public class OrderItem {
    public final String expr;
    public final boolean asc;
    public final Locale collcatorLocale;

    public OrderItem(String expr) {
        this(expr, true);
    }

    public OrderItem(String expr, boolean asc) {
        this(expr, asc, null);
    }

    public OrderItem(String expr, boolean asc, Locale collcatorLocale) {
        this.expr = expr;
        this.asc = asc;
        this.collcatorLocale = collcatorLocale;
    }

    public static OrderItem[] buildOrderItems(String[] exprs, boolean[] descs) {
        OrderItem[] orderItems = new OrderItem[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            String exprStr = exprs[i].trim();
            String collator = null;
            int pos = exprStr.toLowerCase().lastIndexOf(" collate ");
            if (pos > 0) {
                String newExprStr = exprStr.substring(pos).trim();
                if (newExprStr.length() == 0) {
                    exprStr = exprs[i].trim();
                } else {
                    collator = newExprStr.substring("collate ".length()).trim();
                    if (collator.length() == 0) {
                        throw new AlgoException("collate shouldn't be empty.");
                    }
                }
            }
            String[] parts = exprStr.trim().split(" ");
            String sortExpr = parts[0];
            boolean asc = parts.length > 1 ? "asc".equalsIgnoreCase(parts[1]) : (descs == null ? true : !descs[i]);
            Locale locale = null;
            if (collator != null) {
                parts = collator.split("_");
                if (parts.length == 1) {
                    locale = new Locale(parts[0]);
                } else if (parts.length == 2) {
                    locale = new Locale(parts[0], parts[1]);
                } else if (parts.length == 3) {
                    locale = new Locale(parts[0], parts[1], parts[2]);
                } else {
                    throw new AlgoException("Not supported collator: " + (collator == null ? "" : collator));
                }
            }
            orderItems[i] = new OrderItem(sortExpr, asc, locale);
        }
        return orderItems;
    }
}

