/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import kd.bos.algo.AlgoException;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;

class ResultSetRowImpl
extends AbstractRow
implements Serializable {
    private static final long serialVersionUID = -1553549880415022925L;
    private final RowMeta rowMeta;
    private final ResultSet rs;
    private final int[] dataTypeOrdinals;

    public ResultSetRowImpl(RowMeta rowMeta, ResultSet rs) {
        this.dataTypeOrdinals = rowMeta.getDataTypeOrdinals();
        this.rowMeta = rowMeta;
        this.rs = rs;
    }

    @Override
    public Object get(int index) {
        try {
            return this.getObject(this.rs, this.dataTypeOrdinals[index], index, this.rowMeta.isNullable(index));
        }
        catch (SQLException e) {
            String fieldName = null;
            Object value = null;
            try {
                fieldName = this.rowMeta.getFieldName(index);
                value = this.rs.getObject(index + 1);
            }
            catch (Exception ex) {
                throw new AlgoException(ex.getMessage() + ".The field name :[" + (fieldName == null ? "" : fieldName) + "],value:[" + (value == null ? "" : String.valueOf(value)) + "].", e);
            }
            throw new AlgoException(e.getMessage() + ".The field name :[" + (fieldName == null ? "" : fieldName) + "],value:[" + (value == null ? "" : String.valueOf(value)) + "].", e);
        }
    }

    @Override
    public int size() {
        return this.dataTypeOrdinals.length;
    }

    @Override
    public Object[] values() {
        return this.defaultConvertValues();
    }

    @Override
    public String toString() {
        return Arrays.toString(this.values());
    }

    private Object getObject(ResultSet rs, int ordinal, int index, boolean nullable) throws SQLException {
        switch (ordinal) {
            case 0: {
                return rs.getBoolean(index + 1);
            }
            case 2: {
                if (nullable) {
                    Object value = rs.getObject(index + 1);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                }
                return rs.getInt(index + 1);
            }
            case 3: {
                if (nullable) {
                    Object value = rs.getObject(index + 1);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                }
                return rs.getLong(index + 1);
            }
            case 5: {
                return rs.getBigDecimal(index + 1);
            }
            case 1: {
                return rs.getString(index + 1);
            }
            case 6: {
                return rs.getDate(index + 1);
            }
            case 7: {
                return rs.getTimestamp(index + 1);
            }
            case 4: {
                if (nullable) {
                    Object value = rs.getObject(index + 1);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                }
                return rs.getDouble(index + 1);
            }
            case 100: {
                return rs.getObject(index + 1);
            }
            case 8: {
                return rs.getObject(index + 1);
            }
        }
        throw new UnsupportedOperationException("UnImplement for data type :" + ordinal);
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

