/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.io.Serializable;
import java.util.Arrays;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;

public class SettableArrayRow
extends AbstractRow
implements Serializable {
    private static final long serialVersionUID = -1553549880415022925L;
    private final RowMeta rowMeta;
    private Object[] values;

    public SettableArrayRow(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.values = new Object[rowMeta.getFieldCount()];
    }

    public SettableArrayRow(RowMeta rowMeta, Object[] values, boolean needConvert) {
        this.rowMeta = rowMeta;
        this.values = values;
        if (needConvert) {
            for (int i = 0; i < values.length; ++i) {
                values[i] = DataType.convertValue(rowMeta.getField(i).getDataType(), values[i]);
            }
        }
    }

    public void setValue(int index, Object value) {
        this.values[index] = value;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    @Override
    public Object get(int index) {
        return this.values[index];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Object[] values() {
        return this.values;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.values);
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public AbstractRow persist() {
        Object[] copy = Arrays.copyOf(this.values, this.values.length);
        return (AbstractRow)((Object)RowFactory.createPersistedRow(this.getRowMeta(), copy, false));
    }
}

