/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset;

import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.ConstantCalc;

public class UpdateFieldsRow
extends AbstractRow {
    private RowMeta rowMeta;
    private Row innerRow;
    private Calc[] calcs;
    private Map<Integer, Integer> map;

    public UpdateFieldsRow(RowMeta rowMeta, Row innerRow, Calc[] calcs, Map<Integer, Integer> map) {
        this.rowMeta = rowMeta;
        this.innerRow = innerRow;
        this.calcs = calcs;
        this.map = map;
    }

    @Override
    public int size() {
        return this.rowMeta.getFieldCount();
    }

    @Override
    public Object get(int index) {
        if (this.map.containsKey(index)) {
            return this.getNewValue(this.map.get(index));
        }
        return this.innerRow.get(index);
    }

    private Object getNewValue(int index) {
        Calc calc = this.calcs[index];
        if (calc instanceof ConstantCalc) {
            return ((ConstantCalc)calc).getValue();
        }
        return calc.execute(this.innerRow, null);
    }

    @Override
    public Object[] values() {
        return this.defaultConvertValues();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }
}

