/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import java.util.Iterator;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.CachedDataSetImpl;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CachedDataSetBuilder
implements CachedDataSet.Builder {
    private DataSetCacheSpi spi;
    private TraceSpan span = null;

    public CachedDataSetBuilder(RowMeta rowMeta, CacheHint hint) {
        this(rowMeta, hint, null);
    }

    public CachedDataSetBuilder(RowMeta rowMeta, CacheHint hint, String spanTag) {
        this.spi = hint.getStorageType() == null || hint.getStorageType().length() == 0 ? DataSetCacheSpiFactory.getSpi() : DataSetCacheSpiFactory.getSpi(hint.getStorageType());
        this.span = Tracer.create((String)"CachedDataSet", (String)"build");
        if (spanTag != null) {
            this.span.addTag("type", spanTag, true);
        }
        this.spi.open(rowMeta, hint);
    }

    @Override
    public void append(Row row) {
        this.spi.append(row);
    }

    @Override
    public void append(Iterator<Row> iter) {
        this.spi.append(iter);
    }

    @Override
    public CachedDataSet build() {
        try {
            DataSetCacheMeta meta = this.spi.finish();
            this.span.addTag("size", String.valueOf(meta.getRowCount()), false);
            CachedDataSetImpl cachedDataSetImpl = new CachedDataSetImpl(this.spi, meta);
            return cachedDataSetImpl;
        }
        finally {
            this.span.close();
        }
    }
}

