/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.Iterators;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.algo.dataset.streamsource.CachedDataSetDataSet;
import kd.bos.algo.env.Environment;

public class CachedDataSetImpl
implements CachedDataSet {
    private DataSetCacheSpi spi;
    private DataSetCacheMeta meta;
    private String id;
    private boolean closed;

    public CachedDataSetImpl(String id) {
        if (id == null) {
            throw new AlgoException("id is null.");
        }
        this.id = id;
        this.spi = DataSetCacheSpiFactory.getSpi();
        this.meta = this.spi.getMeta(id);
        if (this.meta == null) {
            throw new AlgoException("Cache dataset not found or timed out: " + id);
        }
    }

    public CachedDataSetImpl(String id, String storageType) {
        if (id == null) {
            throw new AlgoException("id is null.");
        }
        this.id = id;
        this.spi = DataSetCacheSpiFactory.getSpi(storageType);
        this.meta = this.spi.getMeta(id);
        if (this.meta == null) {
            throw new AlgoException("Cache dataset not found or timed out: " + id);
        }
    }

    public CachedDataSetImpl(DataSetCacheMeta meta) {
        this.spi = DataSetCacheSpiFactory.getSpi(meta.getStorageType());
        this.meta = meta;
        this.id = meta.getId();
    }

    public CachedDataSetImpl(DataSetCacheSpi spi, DataSetCacheMeta meta) {
        this.spi = spi;
        this.meta = meta;
        this.id = meta.getId();
    }

    private void checkAvailable() {
        if (this.closed) {
            throw new AlgoException("cache dataset has been closed: " + this.id);
        }
    }

    @Override
    public int getRowCount() {
        this.checkAvailable();
        return this.meta.getRowCount();
    }

    @Override
    public Iterator<Row> iterator(int begin, int length) {
        this.checkAvailable();
        if (this.meta.getRowCount() < begin + length && (length = this.meta.getRowCount() - begin) <= 0) {
            return Iterators.empty;
        }
        int pageSize = this.meta.getPageSize();
        if (length <= pageSize) {
            return this.spi.getList(this.meta, begin, length).iterator();
        }
        return new Iterator0(begin, length);
    }

    @Override
    public String getCacheId() {
        return this.id;
    }

    @Override
    public void close() {
        if (this.meta != null) {
            this.spi.delete(this.meta);
        }
        this.meta = null;
        this.closed = true;
    }

    @Override
    public RowMeta getRowMeta() {
        this.checkAvailable();
        return this.meta.getRowMeta();
    }

    @Override
    public List<Row> getList(int begin, int length) {
        this.checkAvailable();
        return this.spi.getList(this.meta, begin, length);
    }

    @Override
    public DataSet toDataSet(Algo algo, boolean closeAlso) {
        return new CachedDataSetDataSet((Environment)algo, this, closeAlso);
    }

    private class Iterator0
    implements Iterator<Row> {
        private int begin;
        private int length;
        private Iterator<Row> current;
        private int pageSize;
        private int rowFetched;
        private boolean eof;

        public Iterator0(int begin, int length) {
            this.begin = begin;
            this.length = length;
            this.pageSize = CachedDataSetImpl.this.meta.getPageSize();
            this.init();
        }

        private void init() {
            int offset = this.begin % this.pageSize;
            this.current = CachedDataSetImpl.this.spi.getList(CachedDataSetImpl.this.meta, this.begin, this.pageSize - offset).iterator();
            this.rowFetched += this.pageSize - offset;
        }

        @Override
        public boolean hasNext() {
            if (this.eof) {
                return false;
            }
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            return this.advance() && this.current.hasNext();
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        private boolean advance() {
            if (this.rowFetched < this.length) {
                if (this.length - this.rowFetched < this.pageSize) {
                    this.current = CachedDataSetImpl.this.spi.getList(CachedDataSetImpl.this.meta, this.begin + this.rowFetched, this.length - this.rowFetched).iterator();
                    this.rowFetched = this.length;
                } else {
                    this.current = CachedDataSetImpl.this.spi.getList(CachedDataSetImpl.this.meta, this.begin + this.rowFetched, this.pageSize).iterator();
                    this.rowFetched += this.pageSize;
                }
                return true;
            }
            return false;
        }
    }
}

