/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache;

import kd.bos.algo.AlgoException;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.fileserver.FileServerTempFileSpiImpl;
import kd.bos.algo.dataset.cache.fs.FSSpiImpl;
import kd.bos.algo.dataset.cache.kv.KVSpiImpl;
import kd.bos.algo.storage.CacheStorage;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.algo.storage.StorageFactory;

public class DataSetCacheSpiFactory {
    public static DataSetCacheSpi getSpi() {
        String type = System.getProperty("algo.storage.datasetcache.type");
        return DataSetCacheSpiFactory.getSpi(type);
    }

    public static DataSetCacheSpi getSpi(String type) {
        if (type == null || "kv".equals(type) || "redis".equals(type)) {
            CacheStorage storage = StorageFactory.getKVStorage();
            return new KVSpiImpl(storage);
        }
        if ("tempfile".equals(type)) {
            return new FileServerTempFileSpiImpl(StorageFactory.getTempFileStorage());
        }
        if ("local".equals(type)) {
            FileSystemStorage storage = StorageFactory.getLocalFileSystemStorage();
            return new FSSpiImpl(storage);
        }
        throw new AlgoException("not support type: " + type);
    }
}

