/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.cache.fs;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.SimpleMetaImpl;
import kd.bos.algo.exception.AlgoExceedAllowMaxRowsException;
import kd.bos.algo.serde.RowSerde;
import kd.bos.algo.storage.FileSystemStorage;
import kd.bos.algo.util.Tuple2;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

public class FSSpiImpl
implements DataSetCacheSpi {
    private FileSystemStorage storage;
    private RowSerde rowSerde;
    private Timer timer;
    private Meter meter;
    private Meter errorMeter;
    private Timer timerByName;
    private Meter meterByName;
    private Meter errorByName;
    private RowMeta rowMeta;
    private CacheHint hint;
    private String cacheId;
    private String baseUrl;
    private ArrayList<Row> buffer = new ArrayList();
    private int pageSize;
    private int rowCount;
    private int pageId;
    private MainThread mainThread = null;

    public FSSpiImpl(FileSystemStorage storage) {
        this.storage = storage;
        this.timer = MetricSystem.timer((String)"kd.metrics.algo.cache.saveTimer");
        this.meter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter");
        this.errorMeter = MetricSystem.meter((String)"kd.metrics.algo.cache.saveMeter.error");
        this.timerByName = MetricSystem.timer((String)("kd.metrics.algo.cache.saveTimer." + storage.getName()));
        this.meterByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter." + storage.getName()));
        this.errorByName = MetricSystem.meter((String)("kd.metrics.algo.cache.saveMeter.error." + storage.getName()));
    }

    @Override
    public void open(RowMeta rowMeta, CacheHint hint) {
        this.rowMeta = rowMeta;
        this.hint = hint;
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        try {
            Tuple2<String, String> strs = this.generateIdAndUrl(hint.getTimeout());
            this.cacheId = (String)strs.t1;
            this.baseUrl = (String)strs.t2;
            this.pageSize = hint.getPageSize();
        }
        catch (IOException e) {
            this.errorMeter.mark();
            this.errorByName.mark();
            throw new AlgoException("can't save dataset cache: " + e.getMessage(), e);
        }
    }

    private boolean isExceedAllowMaxRows() {
        if (this.rowCount > this.hint.getAllowMaxRows()) {
            if (this.hint.isThrowExceptionWhenExceedAllowMaxRows()) {
                AlgoExceedAllowMaxRowsException exception = new AlgoExceedAllowMaxRowsException("DataSetCache exceed allow max rows:[rowCount:" + this.rowCount + ",allowMaxRows:" + this.hint.getAllowMaxRows() + "]");
                if (this.mainThread != null) {
                    this.mainThread.cancelOnException(exception);
                    throw exception;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void append(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.append(iter.next());
        }
    }

    @Override
    public void append(Row row) {
        if (this.isExceedAllowMaxRows()) {
            return;
        }
        this.buffer.add(((AbstractRow)row).persist());
        ++this.rowCount;
        if (this.rowCount % this.pageSize == 0) {
            Page page = new Page(this.pageId++, this.buffer);
            if (this.mainThread == null) {
                this.mainThread = new MainThread(this.cacheId, this.baseUrl, this.rowMeta, this.hint);
            }
            this.mainThread.addPage(page);
            this.buffer = new ArrayList();
        }
    }

    @Override
    public DataSetCacheMeta finish() {
        if (this.buffer.size() > 0) {
            Page page = new Page(this.pageId, this.buffer);
            if (this.mainThread != null) {
                this.mainThread.addPage(page);
            } else {
                this.writePage(this.baseUrl, this.rowMeta, page, this.hint);
            }
        }
        if (this.mainThread != null) {
            this.mainThread.end();
            this.mainThread.waitDone();
        }
        this.buffer = null;
        SimpleMetaImpl meta = new SimpleMetaImpl(this.cacheId, this.rowMeta, this.rowCount, this.hint.getPageSize(), this.hint.getStorageType());
        this.writeMeta(this.baseUrl, meta, this.hint);
        return meta;
    }

    @Override
    public DataSetCacheMeta save(RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        Timer.Context context = this.timer.time();
        Timer.Context contextByName = this.timerByName.time();
        try {
            Tuple2<String, String> strs = this.generateIdAndUrl(hint.getTimeout());
            String id = (String)strs.t1;
            String baseUrl = (String)strs.t2;
            int rowCount = this.writeRows(id, baseUrl, rowMeta, iter, hint);
            this.meter.mark((long)rowCount);
            this.meterByName.mark((long)rowCount);
            SimpleMetaImpl meta = new SimpleMetaImpl(id, rowMeta, rowCount, hint.getPageSize(), hint.getStorageType());
            this.writeMeta(baseUrl, meta, hint);
            SimpleMetaImpl simpleMetaImpl = meta;
            return simpleMetaImpl;
        }
        catch (IOException e) {
            this.errorMeter.mark();
            this.errorByName.mark();
            throw new AlgoException("can't save dataset cache: " + e.getMessage(), e);
        }
        finally {
            context.stop();
            contextByName.stop();
        }
    }

    private void writeMeta(String baseUrl, SimpleMetaImpl meta, CacheHint hint) {
        String url = this.getMetaUrl(baseUrl);
        OutputStream out = null;
        try {
            out = this.storage.create(url, hint.getTimeout());
            out = new BufferedOutputStream(out);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(meta);
            out.flush();
        }
        catch (IOException e) {
            throw new AlgoException("error when write dataset cache meta.", e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public DataSetCacheMeta getMeta(String id) {
        String baseUrl = this.getUrl(id);
        String url = this.getMetaUrl(baseUrl);
        InputStream in = null;
        try {
            DataSetCacheMeta meta;
            in = this.storage.open(url);
            ObjectInputStream ois = new ObjectInputStream(in);
            DataSetCacheMeta dataSetCacheMeta = meta = (DataSetCacheMeta)ois.readObject();
            return dataSetCacheMeta;
        }
        catch (Exception e) {
            throw new AlgoException("error when get dataset cache meta.", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private int writeRows(String cacheId, String baseUrl, RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        Page page;
        int rowCount = 0;
        ArrayList<Row> list = new ArrayList<Row>();
        int pageSize = hint.getPageSize();
        int pageId = 0;
        while (iter.hasNext()) {
            Row row = iter.next();
            if (this.isExceedAllowMaxRows()) continue;
            pageId = rowCount / pageSize;
            row = ((AbstractRow)row).persist();
            list.add(row);
            if (++rowCount % pageSize != 0) continue;
            Page page2 = new Page(pageId, list);
            if (this.mainThread == null) {
                this.mainThread = new MainThread(cacheId, baseUrl, rowMeta, hint);
            }
            this.mainThread.addPage(page2);
            list = new ArrayList();
        }
        if (list.size() > 0) {
            page = new Page(pageId, list);
            if (this.mainThread != null) {
                this.mainThread.addPage(page);
            }
        }
        if (this.mainThread != null) {
            this.mainThread.end();
            this.mainThread.waitDone();
        } else if (list.size() > 0) {
            page = new Page(pageId, list);
            this.writePage(baseUrl, rowMeta, page, hint);
        }
        return rowCount;
    }

    private int writePage(String baseUrl, RowMeta rowMeta, Page page, CacheHint hint) {
        return this.writePage(baseUrl, page.pageId, rowMeta, page.list.iterator(), hint);
    }

    private int writePage(String baseUrl, int pageId, RowMeta rowMeta, Iterator<Row> iter, CacheHint hint) {
        String url = this.getPageUrl(baseUrl, pageId);
        OutputStream out = null;
        try {
            int rowCount;
            out = this.storage.create(url, hint.getTimeout());
            out = new BufferedOutputStream(out);
            DataOutputStream dout = new DataOutputStream(out);
            for (rowCount = 0; iter.hasNext() && rowCount < hint.getPageSize(); ++rowCount) {
                Row row = iter.next();
                this.writeRow(rowMeta, row, dout);
            }
            this.rowSerde.flush(dout);
            int n = rowCount;
            return n;
        }
        catch (IOException e) {
            throw new AlgoException("can't write page: " + e.getMessage(), e);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeRow(RowMeta rowMeta, Row row, DataOutputStream out) {
        this.rowSerde.write(rowMeta, row, out);
    }

    private Row readRow(RowMeta rowMeta, DataInputStream in) {
        if (this.rowSerde == null) {
            this.rowSerde = RowSerde.Factory.get(rowMeta);
        }
        return this.rowSerde.read(rowMeta, in);
    }

    @Override
    public void delete(DataSetCacheMeta meta) {
        this.delete(meta.getId());
    }

    @Override
    public void delete(String id) {
        this.delete(id, true);
    }

    private void delete(String id, boolean throwOnException) {
        block2: {
            try {
                this.storage.delete(this.getUrl(id));
            }
            catch (Exception e) {
                if (!throwOnException) break block2;
                throw AlgoException.wrap(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Row> getList(DataSetCacheMeta meta, int begin, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String generateId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getUrl(String id) {
        return "datasetcache/" + id;
    }

    public Tuple2<String, String> generateIdAndUrl(long timeout) throws IOException {
        String id;
        String url;
        while (!this.storage.createDirectory(url = this.getUrl(id = this.generateId()), timeout)) {
        }
        this.storage.createDirectory(url, timeout);
        return new Tuple2<String, String>(id, url);
    }

    public String getMetaUrl(String baseUrl) {
        return baseUrl + "/meta";
    }

    public String getTimeoutUrl(String baseUrl) {
        return baseUrl + "/timeout";
    }

    public String getPageUrl(String baseUrl, int page) {
        return baseUrl + "/page" + page;
    }

    private class MainThread
    extends Thread {
        private LinkedBlockingQueue<Page> queue = new LinkedBlockingQueue(4);
        private boolean started = false;
        private boolean end = false;
        private CountDownLatch latch = new CountDownLatch(1);
        private RowMeta rowMeta;
        private CacheHint hint;
        private String key1;
        private String baseUrl;
        private AlgoException error;

        public MainThread(String key1, String baseUrl, RowMeta rowMeta, CacheHint hint) {
            this.key1 = key1;
            this.baseUrl = baseUrl;
            this.rowMeta = rowMeta;
            this.hint = hint;
        }

        void end() {
            this.end = true;
        }

        void addPage(Page page) {
            if (this.error != null) {
                this.latch.countDown();
                throw this.error;
            }
            try {
                this.queue.put(page);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.started) {
                this.start();
                this.started = true;
            }
        }

        @Override
        public void run() {
            Page page = null;
            try {
                while (true) {
                    try {
                        page = this.queue.poll(10L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (page == null) {
                        if (!this.end) continue;
                        if (this.error == null) {
                            if (!this.queue.isEmpty()) continue;
                        }
                        break;
                    }
                    if (this.error != null) {
                        break;
                    }
                    this.processOne(page);
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        private void processOne(Page page) {
            try {
                FSSpiImpl.this.writePage(this.baseUrl, this.rowMeta, page, this.hint);
            }
            catch (AlgoException e) {
                this.error = e;
                this.end = true;
            }
            catch (Exception e) {
                this.error = new AlgoException(e);
                this.end = true;
            }
        }

        public void cancelOnException(AlgoException error) {
            this.error = error;
            this.end = true;
            this.waitDone();
            FSSpiImpl.this.delete(this.key1);
        }

        public void waitDone() {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class Page {
        private List<Row> list;
        private int pageId;

        Page(int pageId, List<Row> list) {
            this.pageId = pageId;
            this.list = list;
        }
    }
}

