/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.groupby.AggregatorUtils;
import kd.bos.algo.dataset.groupby.FunctionParam;
import kd.bos.algo.dataset.groupby.GroupParam;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.dataset.groupby.LimitedHashCountDistinctGrouper;
import kd.bos.algo.dataset.groupby.MergedCountDistinctIterator;
import kd.bos.algo.dataset.groupby.OrderCountDistinctIterator;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.agg.IAgg;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.sql.tree.calc.CountDistinctCalc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;

class GroupByCountDistinctDataSet
extends AbstractDataSet {
    private GroupbyInfo info;
    private String[] groupFields;
    private boolean forceOrderByPolicy;
    private boolean[] descs;
    private Aggregator[] aggregators;
    private Calc[] groupCalcs;
    private Calc[] aggCalcs;
    private OrderItem[] orderItems;
    private Store orderStore;
    private AbstractDataSet input = null;
    private int hashLimit = 0;
    private boolean groupIsAllNulls;
    private String policy = AlgoConfiguration.COUNTDISTINCT_POLICY.getString();

    public GroupByCountDistinctDataSet(AbstractDataSet dataSet, GroupbyInfo info, boolean forceOrderByPolicy) {
        super("GroupBy", dataSet);
        this.info = info;
        this.groupFields = info.getGroups();
        this.forceOrderByPolicy = forceOrderByPolicy;
        this.buildMeta();
        this.buildOrderItems();
        if (info.getGroups() != null) {
            this.groupIsAllNulls = this.groupIsAllNulls();
        }
        this.hashLimit = AlgoConfiguration.GROUPBY_HASH_TRESHOLD.getInt();
    }

    private void buildOrderItems() {
        if (this.groupFields != null && this.groupFields.length > 0) {
            String[] orderKeys = this.info.getGroups();
            this.descs = this.info.getOrderByDescs();
            if (this.descs == null) {
                this.descs = new boolean[orderKeys.length];
            }
            this.orderItems = new OrderItem[orderKeys.length];
            for (int i = 0; i < orderKeys.length; ++i) {
                this.orderItems[i] = new OrderItem(orderKeys[i], !this.descs[i]);
            }
        }
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        if ("order".equals(this.policy) || this.forceOrderByPolicy) {
            this.checkClosed();
            this.input = this.getInput(0);
            CountDistinctCalc calc = (CountDistinctCalc)this.getCountDistinctCalc(this.aggCalcs).get(0);
            int[] distinctFieldIndices = calc.getDistinctFieldIndices();
            this.orderItems = this.rebuildOrderItems(calc.getDistinctFieldIndices());
            this.orderStore = StoreFactory.createOrderStore(this.input.getRowMeta(), this.orderItems);
            this.orderStore.write(this.input.innerIterator());
            this.detachInputs(false);
            return new OrderCountDistinctIterator(this.orderStore.getRowIterator(), this.groupCalcs, this.aggCalcs, this.aggregators, this.rowMeta, distinctFieldIndices, this.groupIsAllNulls);
        }
        this.checkClosed();
        this.input = this.getInput(0);
        InnerRowIterator sourceIter = this.input.innerIterator();
        FunctionParam param = new FunctionParam(this.groupCalcs, this.aggCalcs, this.aggregators, this.descs);
        LimitedHashCountDistinctGrouper countDistinctGrouper = new LimitedHashCountDistinctGrouper(sourceIter, param, this.rowMeta, this.groupIsAllNulls);
        boolean finished = countDistinctGrouper.build(this.hashLimit);
        if (finished && !sourceIter.hasNext()) {
            this.detachInputs(true);
            return countDistinctGrouper.getIterator(true);
        }
        List<Calc> countDistinctCalcs = this.getCountDistinctCalc(this.aggCalcs);
        return this.handleOneCountDistinct(countDistinctGrouper.getMapIter(true), countDistinctCalcs, sourceIter, param);
    }

    private MergedCountDistinctIterator handleOneCountDistinct(Iterator<Map.Entry<ArrayKey, Object[]>> mapIterator, List<Calc> countDistinctCalcs, Iterator<Row> sourceIter, FunctionParam param) {
        CountDistinctCalc calc = (CountDistinctCalc)countDistinctCalcs.get(0);
        this.orderItems = this.rebuildOrderItems(calc.getDistinctFieldIndices());
        this.orderStore = StoreFactory.createOrderStore(this.input.getRowMeta(), this.orderItems);
        this.orderStore.write(sourceIter);
        Iterator<Row> rowIter = this.orderStore.getRowIterator();
        this.detachInputs(true);
        GroupParam groupParam = new GroupParam(mapIterator, calc.getDistinctFieldIndices(), this.groupIsAllNulls);
        return new MergedCountDistinctIterator(rowIter, param, this.rowMeta, groupParam);
    }

    private List<Calc> getCountDistinctCalc(Calc[] aggCalcs) {
        ArrayList<Calc> list = new ArrayList<Calc>(4);
        for (Calc calc : aggCalcs) {
            if (!(calc instanceof CountDistinctCalc)) continue;
            list.add(calc);
        }
        return list;
    }

    private OrderItem[] rebuildOrderItems(int[] distinctFieldIndices) {
        int orderLength = 0;
        if (this.orderItems != null && !this.groupIsAllNulls) {
            orderLength = this.orderItems.length;
        }
        OrderItem[] newOrderItems = new OrderItem[orderLength + distinctFieldIndices.length];
        if (this.orderItems != null && !this.groupIsAllNulls) {
            for (int i = 0; i < this.orderItems.length; ++i) {
                newOrderItems[i] = this.orderItems[i];
            }
        }
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        for (int i = 0; i < distinctFieldIndices.length; ++i) {
            newOrderItems[i + orderLength] = new OrderItem(rowMeta.getField(distinctFieldIndices[i]).getName(), true);
        }
        return newOrderItems;
    }

    private void buildMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta innerRowType = dataSet.getRowMeta();
        ExprParser parser = new ExprParser(innerRowType);
        Alias[] aggAliasExprs = parser.transformAlias(parser.resolve(this.info.getAggExprs()));
        this.aggCalcs = new Calc[aggAliasExprs.length];
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            this.aggCalcs[i] = CalcCompiler.compile(innerRowType, aggAliasExprs[i]);
        }
        ArrayList<Field> targetFields = new ArrayList<Field>();
        if (this.groupFields != null && this.groupFields.length > 0) {
            Alias[] groupExprs = new Alias[this.groupFields.length];
            this.groupCalcs = new Calc[this.groupFields.length];
            for (int i = 0; i < this.groupFields.length; ++i) {
                Expr expr = parser.parse(this.groupFields[i]);
                this.groupCalcs[i] = CalcCompiler.compile(innerRowType, expr);
                groupExprs[i] = parser.transformAlias(expr);
                Field targetField = new Field(groupExprs[i].getAlias(), expr.getDataType());
                targetFields.add(targetField);
            }
        }
        this.aggregators = new Aggregator[aggAliasExprs.length];
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            IAgg aggExpr = (IAgg)((Object)aggAliasExprs[i].getChild());
            this.aggregators[i] = AggregatorUtils.getAggregator(aggExpr);
            String alias = aggAliasExprs[i].getAlias();
            DataType dataType = aggExpr.getDataType();
            Field targetField = new Field(alias, dataType);
            targetFields.add(targetField);
        }
        this.rowMeta = new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    private boolean groupIsAllNulls() {
        String[] orderKeys = this.info.getGroups();
        RowMeta rowMeta = this.getInput(0).getRowMeta();
        for (int i = 0; i < orderKeys.length; ++i) {
            DataType dataType = rowMeta.getField(orderKeys[i]).getDataType();
            if (dataType instanceof NullType) continue;
            return false;
        }
        return true;
    }

    @Override
    public void realClose() {
        if (this.orderStore != null) {
            this.orderStore.close();
        }
        if (this.input != null) {
            this.input.close();
        }
    }
}

