/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.groupby.ArrayKeyComparator;
import kd.bos.algo.dataset.groupby.FunctionParam;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.algo.dataset.store.HashMapStore;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CountDistinctCalc;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.ArrayKey;
import kd.bos.algo.util.Constants;
import kd.bos.algo.util.ResultEnum;

class LimitedHashCountDistinctGrouper {
    private Iterator<Row> iter;
    private Aggregator[] aggregators;
    private boolean[] descs;
    private RowMeta targetRowMeta;
    private Calc[] groupCalcs;
    private Calc[] aggCalcs;
    private int treeMaxSize = AlgoConfiguration.COUNTDISTINCT_TRIE_MAXSIZE.getInt();
    private boolean overMaxSize;
    private boolean groupIsAllNulls;
    boolean[] isCountDistincts;
    private HashMapStore<ArrayKey, Object[]> mapStore;

    public LimitedHashCountDistinctGrouper(Iterator<Row> iter, FunctionParam param, RowMeta targetRowMeta, boolean groupIsAllNulls) {
        this.iter = iter;
        this.groupCalcs = param.getGroupCalcs();
        this.descs = param.getDescs();
        this.aggCalcs = param.getAggCalcs();
        this.aggregators = param.getAggregators();
        this.targetRowMeta = targetRowMeta;
        this.groupIsAllNulls = groupIsAllNulls;
        this.initIsCountDistinct();
    }

    private void initIsCountDistinct() {
        this.isCountDistincts = new boolean[this.aggCalcs.length];
        for (int i = 0; i < this.aggCalcs.length; ++i) {
            if (!(this.aggCalcs[i] instanceof CountDistinctCalc)) continue;
            this.isCountDistincts[i] = true;
        }
    }

    public boolean build(int limit) {
        if (this.mapStore != null) {
            this.mapStore.close();
        }
        this.mapStore = StoreFactory.createHashMapStore((this.groupCalcs == null ? 0 : this.groupCalcs.length) + this.aggCalcs.length);
        while (this.iter.hasNext()) {
            if (this.mapStore.size() > limit || this.overMaxSize) {
                return false;
            }
            Row row = this.iter.next();
            this.processRow(row);
        }
        return true;
    }

    private void processRow(Row row) {
        int i;
        ArrayKey gk;
        if (this.groupCalcs == null) {
            gk = new ArrayKey(new Object[0]);
        } else {
            Object[] keys = new Object[this.groupCalcs.length];
            for (i = 0; i < keys.length; ++i) {
                keys[i] = this.groupIsAllNulls ? "null" : this.groupCalcs[i].execute(row, null);
            }
            gk = new ArrayKey(keys);
        }
        Object[] aggValues = this.mapStore.get(gk);
        if (aggValues == null) {
            aggValues = new Object[this.aggregators.length];
            this.mapStore.put(gk, aggValues);
        }
        for (i = 0; i < this.aggregators.length; ++i) {
            Object value = this.aggCalcs[i].execute(row, null);
            if (this.isCountDistincts[i]) {
                long trieTreeSize = ((CountDistinctCalc)this.aggCalcs[i]).getTrieTreeSize();
                if (trieTreeSize >= (long)this.treeMaxSize) {
                    this.overMaxSize = true;
                    value = Constants.ONE_LONG;
                }
                if (value == ResultEnum.NOT_EXISTS) {
                    value = Constants.ONE_LONG;
                } else if (value == ResultEnum.EXISTS) {
                    value = Constants.ZERO_LONG;
                }
            }
            aggValues[i] = this.aggregators[i].appendValue(aggValues[i], value);
        }
    }

    private TreeMap sort() {
        TreeMap<ArrayKey, Object[]> tm = new TreeMap<ArrayKey, Object[]>(new ArrayKeyComparator(this.descs));
        Iterator<Map.Entry<ArrayKey, Object[]>> iter = this.mapStore.entryIterator();
        while (iter.hasNext()) {
            Map.Entry<ArrayKey, Object[]> entry = iter.next();
            tm.put(entry.getKey(), entry.getValue());
        }
        this.mapStore.close();
        this.mapStore = null;
        return tm;
    }

    public InnerRowIterator getIterator(boolean sort) {
        final Iterator<Map.Entry<ArrayKey, Object>> mapIter = sort && this.groupCalcs != null && !this.groupIsAllNulls ? this.sort().entrySet().iterator() : this.mapStore.entryIterator();
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return mapIter.hasNext();
            }

            @Override
            public Row _next() {
                Map.Entry entry = (Map.Entry)mapIter.next();
                return LimitedHashCountDistinctGrouper.this.makeTargetRow((ArrayKey)entry.getKey(), (Object[])entry.getValue());
            }
        };
    }

    public Iterator<Map.Entry<ArrayKey, Object[]>> getMapIter(boolean sort) {
        Iterator<Map.Entry<ArrayKey, Object>> mapIter = sort && this.groupCalcs != null && !this.groupIsAllNulls ? this.sort().entrySet().iterator() : this.mapStore.entryIterator();
        return mapIter;
    }

    public void close() {
        if (this.mapStore != null) {
            this.mapStore.close();
            this.mapStore = null;
        }
    }

    protected Row makeTargetRow(ArrayKey groupKeys, Object[] aggValues) {
        return new GroupByRow(this.targetRowMeta, groupKeys, aggValues, this.aggregators);
    }
}

