/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.groupby;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.groupby.AggregatorUtils;
import kd.bos.algo.dataset.groupby.GroupbyInfo;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.UnaryExpr;
import kd.bos.algo.sql.tree.agg.IAgg;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;
import kd.bos.algo.util.Aggregator;

public class SingleGroupByDataSet
extends AbstractDataSet {
    private GroupbyInfo info;
    private Aggregator[] aggregators;
    private Iterator<Row> iter;
    private Calc[] aggCalcs;

    public SingleGroupByDataSet(AbstractDataSet dataSet, GroupbyInfo info) {
        super("SingleGroupBy", dataSet);
        this.info = info;
        this.buildMeta();
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        this.iter = dataSet.innerIterator();
        if (!this.iter.hasNext()) {
            return InnerRowIterator.EMPTY;
        }
        return new InnerRowIterator(){
            private boolean nexted = false;

            @Override
            public boolean _hasNext() {
                return !this.nexted;
            }

            @Override
            public Row _next() {
                if (this.nexted) {
                    throw new NoSuchElementException();
                }
                Row next = SingleGroupByDataSet.this.nextGroup();
                this.nexted = true;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void buildMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta innerRowType = dataSet.getRowMeta();
        ExprParser parser = new ExprParser(innerRowType);
        Expr[] aggAliasExprs = parser.transformAlias(parser.resolve(this.info.getAggExprs()));
        this.aggCalcs = CalcCompiler.compile(innerRowType, aggAliasExprs);
        ArrayList<Field> targetFields = new ArrayList<Field>();
        this.aggregators = new Aggregator[aggAliasExprs.length];
        for (int i = 0; i < aggAliasExprs.length; ++i) {
            IAgg aggExpr = (IAgg)((Object)((UnaryExpr)aggAliasExprs[i]).getChild());
            this.aggregators[i] = AggregatorUtils.getAggregator(aggExpr);
            String alias = ((Alias)aggAliasExprs[i]).getAlias();
            DataType dataType = aggExpr.getDataType();
            Field targetField = new Field(alias, dataType);
            targetFields.add(targetField);
        }
        this.rowMeta = new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    public Row nextGroup() {
        Object[] aggValues = new Object[this.aggregators.length];
        while (this.iter.hasNext()) {
            Row row = this.iter.next();
            for (int i = 0; i < this.aggregators.length; ++i) {
                Object v = this.aggCalcs[i].execute(row, null);
                aggValues[i] = this.aggregators[i].appendValue(aggValues[i], v);
            }
        }
        Row targetRow = this.makeTargetRow(aggValues);
        return targetRow;
    }

    private Row makeTargetRow(Object[] aggValues) {
        Object[] values = new Object[aggValues.length];
        for (int i = 0; i < aggValues.length; ++i) {
            values[i] = this.aggregators[i].getValue(aggValues[i]);
        }
        return RowFactory.createRow(this.rowMeta, values);
    }

    @Override
    public void realClose() {
    }
}

