/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.HashTable;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.hashjoin.AbstractHashTable;
import kd.bos.algo.dataset.hashjoin.HashJoinDataSetBuilder;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;

public class FakeHashJoinDataSet
extends AbstractDataSet {
    private ArrayList<Field> targetFields;
    private HashTable[] hashTables;
    private String[] joinKeyFields;
    private List<Boolean> includeNotExists;
    private HashJoinDataSetBuilder builder;
    private DataSet mainDataSet = null;

    public FakeHashJoinDataSet(AbstractDataSet dataSet, HashJoinDataSetBuilder builder) {
        super("HashJoin", dataSet);
        this.builder = builder;
        if (builder.getHashTables().length != builder.getJoinKeyFields().length) {
            throw new AlgoException("hash join key fields count not match hashTables count:" + builder.getHashTables().length + "!=" + builder.getJoinKeyFields().length);
        }
        this.hashTables = builder.getHashTables();
        this.joinKeyFields = builder.getJoinKeyFields();
        this.includeNotExists = builder.getIncludeNotExists();
        this.buildMeta(builder);
    }

    private void buildMeta(HashJoinDataSetBuilder builder) {
        RowMeta factRowType = this.getInput(0).getRowMeta();
        HashTable[] hashTables = builder.getHashTables();
        this.targetFields = new ArrayList();
        ExprParser parser = new ExprParser(factRowType);
        Expr[] exprs = parser.parse(builder.getLeftFields());
        Alias[] factAlias = parser.transformAlias(exprs);
        this.addFieldsFromExprs(this.targetFields, factRowType, factAlias);
        for (int i = 0; i < hashTables.length; ++i) {
            parser = new ExprParser(hashTables[i].getRowMeta());
            Alias[] hashAlias = null;
            String[] selectFields = builder.getHashTableFields(i);
            if (selectFields == null) {
                throw AlgoException.create("HashJoin should select hashTable fields", new Object[0]);
            }
            for (Alias expr : hashAlias = parser.transformAlias(parser.parse(selectFields))) {
                Field field = new Field(expr.getAlias(), expr.getDataType());
                this.targetFields.add(field);
            }
        }
        this.rowMeta = new RowMeta(this.targetFields.toArray(new Field[this.targetFields.size()]));
    }

    private void addFieldsFromExprs(ArrayList<Field> targetFields, RowMeta rowType, Alias[] exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            Field field = new Field(exprs[i].getAlias(), exprs[i].getDataType());
            targetFields.add(field);
        }
    }

    @Override
    public final RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        this.mainDataSet = this.getInput(0);
        ArrayList<String> resultFields = new ArrayList<String>();
        for (String str : this.builder.getLeftFields()) {
            resultFields.add(str);
        }
        for (int i = 0; i < this.hashTables.length; ++i) {
            this.mainDataSet = this.joinTable(this.mainDataSet, i, resultFields);
        }
        this.mainDataSet = this.mainDataSet.select(resultFields.toArray(new String[0]));
        return InnerRowIterator.wrapper(this.mainDataSet);
    }

    private DataSet joinTable(DataSet mainDataSet, int index, ArrayList<String> resultFields) {
        AbstractHashTable hashTable = (AbstractHashTable)this.hashTables[index];
        DataSet ds = hashTable.toDataSet();
        String rightKeyField = hashTable.getKeyField();
        String[] rightFields = this.builder.getHashTableFields(index);
        JoinDataSet joinDataSet = mainDataSet.join(ds, this.includeNotExists.get(index) != false ? JoinType.LEFT : JoinType.INNER);
        joinDataSet.on(this.joinKeyFields[index], rightKeyField);
        String[] leftFields = this.getLeftFields(mainDataSet);
        joinDataSet.select(leftFields, rightFields);
        DataSet result = joinDataSet.finish();
        RowMeta rowMeta = result.getRowMeta();
        for (int i = leftFields.length; i < rowMeta.getFieldCount(); ++i) {
            resultFields.add(rowMeta.getFieldAlias(i));
        }
        return result;
    }

    private String[] getLeftFields(DataSet mainDataSet) {
        RowMeta rowMeta = mainDataSet.getRowMeta();
        String[] result = new String[rowMeta.getFieldCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = rowMeta.getFieldAlias(i);
        }
        return result;
    }

    @Override
    public void realClose() {
        for (HashTable hashTable : this.hashTables) {
            hashTable.close();
        }
        if (this.mainDataSet != null) {
            this.mainDataSet.close();
        }
    }
}

