/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.HashTable;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.hashjoin.AbstractHashTable;
import kd.bos.algo.dataset.hashjoin.FakeHashJoinDataSet;
import kd.bos.algo.dataset.hashjoin.StarHashJoinDataSet;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;

public class HashJoinDataSetBuilder
implements HashJoinDataSet {
    private transient AbstractDataSet leftDataSet;
    private ArrayList<HashTable> hashTables = new ArrayList();
    private ArrayList<Boolean> includeNotExists = new ArrayList();
    private ArrayList<String> joinKeyFields = new ArrayList();
    private String[] leftFields;
    private ArrayList<String[]> hashTableFieldss = new ArrayList();
    private ArrayList<JoinHint> hintList = new ArrayList();

    public HashJoinDataSetBuilder(AbstractDataSet leftDataSet) {
        this.leftDataSet = leftDataSet;
    }

    public HashJoinDataSetBuilder(AbstractDataSet leftDataSet, HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields, boolean includeNotExist) {
        this.leftDataSet = leftDataSet;
        this.addHashTable(hashTable, leftJoinKeyField, hashTableSelectFields, includeNotExist);
    }

    @Override
    public final HashJoinDataSet addHashTable(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields) {
        return this.addHashTable(hashTable, leftJoinKeyField, hashTableSelectFields, false);
    }

    @Override
    public final HashJoinDataSet addHashTable(HashTable hashTable, String leftJoinKeyField, String[] hashTableSelectFields, boolean includeNotExist) {
        this.hashTables.add(hashTable);
        this.joinKeyFields.add(leftJoinKeyField);
        this.hashTableFieldss.add(hashTableSelectFields);
        this.includeNotExists.add(includeNotExist);
        return this;
    }

    @Override
    public HashJoinDataSet selectLeftFields(String[] leftFields) {
        this.leftFields = leftFields;
        return this;
    }

    @Override
    public HashJoinDataSet hint(JoinHint hint) {
        this.hintList.add(hint);
        return this;
    }

    @Override
    public DataSet finish() {
        if (this.leftFields == null) {
            throw new AlgoException("Left fields required, please invoke selectLeftFields(String[] leftFields) before finish()");
        }
        ArrayList<Integer> exceedHashTables = new ArrayList<Integer>(1);
        ArrayList<Integer> notExceedHashTables = new ArrayList<Integer>();
        for (int i = 0; i < this.hashTables.size(); ++i) {
            HashTable ht = this.hashTables.get(i);
            if (((AbstractHashTable)ht).exceedMemory()) {
                exceedHashTables.add(i);
                continue;
            }
            notExceedHashTables.add(i);
        }
        if (exceedHashTables.size() > 0) {
            DataSet r = notExceedHashTables.size() == 0 ? new FakeHashJoinDataSet(this.leftDataSet, this) : this.createHybridDataSet(exceedHashTables, notExceedHashTables);
            this.leftDataSet = null;
            return r;
        }
        StarHashJoinDataSet r = new StarHashJoinDataSet(this.leftDataSet, this);
        this.leftDataSet = null;
        return r;
    }

    private DataSet createHybridDataSet(ArrayList<Integer> exceedHashTables, ArrayList<Integer> notExceedHashTables) {
        HashJoinDataSetBuilder starBuilder = new HashJoinDataSetBuilder(this.leftDataSet);
        starBuilder.hintList = this.hintList;
        ArrayList<String> newLeftFields = new ArrayList<String>();
        ArrayList<String> newJoinKeyFields = new ArrayList<String>();
        for (String field : this.leftFields) {
            newLeftFields.add(field);
        }
        for (Integer i : notExceedHashTables) {
            starBuilder.addHashTable(this.hashTables.get(i), this.joinKeyFields.get(i), this.hashTableFieldss.get(i), this.includeNotExists.get(i));
        }
        newJoinKeyFields.addAll(this.joinKeyFields);
        for (Integer i : exceedHashTables) {
            if (newLeftFields.contains(newJoinKeyFields.get(i))) continue;
            String tempLeftJoinFieldAlias = "ALGO__" + (String)newJoinKeyFields.get(i);
            String tempLeftJoinFieldExpr = (String)newJoinKeyFields.get(i) + " as " + tempLeftJoinFieldAlias;
            if (!newLeftFields.contains(tempLeftJoinFieldExpr)) {
                newLeftFields.add(tempLeftJoinFieldExpr);
            }
            newJoinKeyFields.set(i, tempLeftJoinFieldAlias);
        }
        starBuilder.leftFields = newLeftFields.toArray(new String[newLeftFields.size()]);
        DataSet mainDataSet = new StarHashJoinDataSet(this.leftDataSet, starBuilder);
        for (Integer index : exceedHashTables) {
            AbstractHashTable hashTable = (AbstractHashTable)this.hashTables.get(index);
            DataSet ds = hashTable.toDataSet();
            String rightKeyField = hashTable.getKeyField();
            String[] rightFields = this.getHashTableFields(index);
            JoinDataSet joinDataSet = mainDataSet.join(ds, this.includeNotExists.get(index) != false ? JoinType.LEFT : JoinType.INNER);
            joinDataSet.on((String)newJoinKeyFields.get(index), rightKeyField);
            String[] leftAllFields = this.getAllFields(mainDataSet);
            joinDataSet.select(leftAllFields, rightFields);
            mainDataSet = joinDataSet.finish();
        }
        String[] resultFields = this.buildFinalFields(this);
        mainDataSet = mainDataSet.select(resultFields);
        return mainDataSet;
    }

    private String[] getAllFields(DataSet mainDataSet) {
        RowMeta rowMeta = mainDataSet.getRowMeta();
        String[] result = new String[rowMeta.getFieldCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = rowMeta.getFieldAlias(i);
        }
        return result;
    }

    private String[] buildFinalFields(HashJoinDataSetBuilder builder) {
        Alias[] factAlias;
        RowMeta factRowType = this.leftDataSet.getRowMeta();
        HashTable[] hashTables = builder.getHashTables();
        ArrayList<String> targetFields = new ArrayList<String>();
        ExprParser parser = new ExprParser(factRowType);
        Expr[] exprs = parser.parse(builder.getLeftFields());
        for (Alias alias : factAlias = parser.transformAlias(exprs)) {
            targetFields.add(alias.getAlias());
        }
        for (int i = 0; i < hashTables.length; ++i) {
            parser = new ExprParser(hashTables[i].getRowMeta());
            Alias[] hashAlias = null;
            String[] selectFields = builder.getHashTableFields(i);
            if (selectFields == null) {
                throw AlgoException.create("HashJoin should select hashTable fields", new Object[0]);
            }
            for (Alias alias : hashAlias = parser.transformAlias(parser.parse(selectFields))) {
                targetFields.add(alias.getAlias());
            }
        }
        return targetFields.toArray(new String[targetFields.size()]);
    }

    public String[] getLeftFields() {
        return this.leftFields;
    }

    public String[] getHashTableFields(int index) {
        return this.hashTableFieldss.get(index);
    }

    public List<JoinHint> getHintList() {
        return this.hintList;
    }

    public HashTable[] getHashTables() {
        return this.hashTables.toArray(new HashTable[this.hashTables.size()]);
    }

    public String[] getJoinKeyFields() {
        return this.joinKeyFields.toArray(new String[this.joinKeyFields.size()]);
    }

    public List<Boolean> getIncludeNotExists() {
        return this.includeNotExists;
    }
}

