/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.HashTable;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.hashjoin.AbstractHashTable;
import kd.bos.algo.dataset.store.HashMapStore;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.dataset.store.mm.MMMapLimit;

public class SmartHashTable
extends AbstractHashTable
implements HashTable {
    private RowMeta rowMeta;
    private HashMapStore<Object, Row> mapStore = null;
    private int keyIndex;
    private int maxMemRowCount;
    private DataSet resultDataSet;
    private int rowCount;

    public SmartHashTable(DataSet dataSet, int keyIndex, int maxMemRowCount) {
        this.keyIndex = keyIndex;
        this.maxMemRowCount = maxMemRowCount;
        this.rowMeta = dataSet.getRowMeta();
        this.build(dataSet);
    }

    private void build(DataSet dataSet) {
        int rowIndex = 0;
        DataSetBuilder builder = null;
        if (!MMMapLimit.exceedLimit()) {
            this.mapStore = StoreFactory.createHashMapStore(dataSet.getRowMeta().getFieldCount());
        } else {
            builder = this.builder(this.rowMeta);
        }
        for (Row row : dataSet) {
            ++rowIndex;
            if (builder != null) {
                builder.append(row);
                continue;
            }
            if (rowIndex == this.maxMemRowCount) {
                builder = this.builder(this.rowMeta);
                builder.append(row);
                continue;
            }
            this.mapStore.put(row.get(this.keyIndex), ((AbstractRow)row).persist());
        }
        if (builder != null) {
            this.resultDataSet = builder.build();
        }
        this.rowCount = rowIndex;
    }

    private DataSetBuilder builder(RowMeta rowMeta) {
        Algo algo = Algo.create("algo.hashjoin");
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        if (this.mapStore != null) {
            for (Row row : this.mapStore.values()) {
                builder.append(row);
            }
            this.mapStore.close();
        }
        return builder;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public Row lookup(Object key) {
        return this.mapStore.get(key);
    }

    @Override
    public void close() {
        if (this.resultDataSet != null) {
            this.resultDataSet.close();
        }
        if (this.mapStore != null) {
            this.mapStore.close();
        }
    }

    @Override
    public DataSet toDataSet() {
        if (this.resultDataSet != null) {
            return this.resultDataSet;
        }
        DataSetBuilder builder = this.builder(this.rowMeta);
        this.resultDataSet = builder.build();
        return this.resultDataSet;
    }

    @Override
    public boolean exceedMemory() {
        return this.resultDataSet != null;
    }

    @Override
    public String getKeyField() {
        return this.rowMeta.getFieldAlias(this.keyIndex);
    }

    public int getRowCount() {
        return this.rowCount;
    }
}

