/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.hashjoin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.HashTable;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.dataset.hashjoin.AbstractHashTable;
import kd.bos.algo.dataset.hashjoin.HashJoinDataSetBuilder;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CalcCompiler;

public class StarHashJoinDataSet
extends AbstractDataSet {
    private ArrayList<Field> targetFields;
    private Calc[] factCalcs;
    private ArrayList<Calc[]> lookupCalcs = new ArrayList(4);
    private HashTable[] hashTables;
    private int[] joinKeyFieldIndexes;
    private boolean[] unIncludeNotExists;

    public StarHashJoinDataSet(AbstractDataSet dataSet, HashJoinDataSetBuilder builder) {
        super("HashJoin", dataSet);
        int i;
        this.hashTables = builder.getHashTables();
        String[] joinKeyFields = builder.getJoinKeyFields();
        if (this.hashTables.length != joinKeyFields.length) {
            throw new AlgoException("hash join key fields count not match hashTables count:" + this.hashTables.length + "!=" + joinKeyFields.length);
        }
        List<Boolean> includeNotExistsList = builder.getIncludeNotExists();
        this.unIncludeNotExists = new boolean[includeNotExistsList.size()];
        int n = this.unIncludeNotExists.length;
        for (i = 0; i < n; ++i) {
            this.unIncludeNotExists[i] = includeNotExistsList.get(i) == false;
        }
        this.buildMeta(builder);
        this.joinKeyFieldIndexes = new int[joinKeyFields.length];
        n = joinKeyFields.length;
        for (i = 0; i < n; ++i) {
            this.joinKeyFieldIndexes[i] = dataSet.getRowMeta().getFieldIndex(joinKeyFields[i]);
        }
    }

    private void buildMeta(HashJoinDataSetBuilder builder) {
        RowMeta factRowType = this.getInput(0).getRowMeta();
        this.targetFields = new ArrayList();
        ExprParser parser = new ExprParser(factRowType);
        Expr[] exprs = parser.parse(builder.getLeftFields());
        this.factCalcs = CalcCompiler.compile(factRowType, exprs);
        Alias[] factAlias = parser.transformAlias(exprs);
        this.addFieldsFromExprs(this.targetFields, factRowType, factAlias);
        for (int i = 0; i < this.hashTables.length; ++i) {
            parser = new ExprParser(this.hashTables[i].getRowMeta());
            Expr[] hashAlias = null;
            String[] selectFields = builder.getHashTableFields(i);
            if (selectFields == null) {
                throw AlgoException.create("HashJoin should select hashTable fields", new Object[0]);
            }
            for (Alias alias : hashAlias = parser.transformAlias(parser.parse(selectFields))) {
                Field field = new Field(alias.getAlias(), alias.getDataType());
                this.targetFields.add(field);
            }
            Calc[] calcs = CalcCompiler.compile(this.hashTables[i].getRowMeta(), hashAlias);
            this.lookupCalcs.add(calcs);
        }
        this.rowMeta = new RowMeta(this.targetFields.toArray(new Field[this.targetFields.size()]));
    }

    private void addFieldsFromExprs(ArrayList<Field> targetFields, RowMeta rowType, Alias[] exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            Field field = new Field(exprs[i].getAlias(), exprs[i].getDataType());
            targetFields.add(field);
        }
    }

    @Override
    public final RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        return new MyIterator(this.rowMeta, this.getInput(0).innerIterator(), this.targetFields);
    }

    @Override
    public void realClose() {
        for (HashTable hashTable : this.hashTables) {
            hashTable.close();
        }
    }

    private class MyIterator
    extends InnerRowIterator {
        private RowMeta rowMeta;
        private Iterator<Row> iter;
        private Row currentRow = null;
        private Row[] lrows;
        private int n;

        public MyIterator(RowMeta rowMeta, Iterator<Row> iterator, ArrayList<Field> targetFields) {
            this.rowMeta = rowMeta;
            this.iter = iterator;
            this.n = StarHashJoinDataSet.this.hashTables.length;
            this.lrows = new Row[this.n];
            this.currentRow = this.nextRow();
        }

        private Row nextRow() {
            if (!this.iter.hasNext()) {
                return null;
            }
            if (this.n == 1) {
                do {
                    Row row = this.iter.next();
                    Object key = row.get(StarHashJoinDataSet.this.joinKeyFieldIndexes[0]);
                    this.lrows[0] = ((AbstractHashTable)StarHashJoinDataSet.this.hashTables[0]).lookup(key);
                    if (this.lrows[0] == null && StarHashJoinDataSet.this.unIncludeNotExists[0]) continue;
                    return this.makeTargetRow(row, this.lrows);
                } while (this.iter.hasNext());
                return null;
            }
            do {
                Row row = this.iter.next();
                boolean skip = false;
                for (int i = 0; i < this.n; ++i) {
                    Object key = row.get(StarHashJoinDataSet.this.joinKeyFieldIndexes[i]);
                    this.lrows[i] = ((AbstractHashTable)StarHashJoinDataSet.this.hashTables[i]).lookup(key);
                    if (this.lrows[i] != null || !StarHashJoinDataSet.this.unIncludeNotExists[i]) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                return this.makeTargetRow(row, this.lrows);
            } while (this.iter.hasNext());
            return null;
        }

        private Row makeTargetRow(Row row, Row[] lrows) {
            int i;
            ArrayList<Object> list = new ArrayList<Object>();
            for (i = 0; i < StarHashJoinDataSet.this.factCalcs.length; ++i) {
                list.add(StarHashJoinDataSet.this.factCalcs[i].execute(row, null));
            }
            for (i = 0; i < lrows.length; ++i) {
                Calc[] calcs = (Calc[])StarHashJoinDataSet.this.lookupCalcs.get(i);
                for (int j = 0; j < calcs.length; ++j) {
                    list.add(calcs[j].execute(lrows[i], null));
                }
            }
            return RowFactory.createRow(this.rowMeta, list.toArray(new Object[list.size()]));
        }

        @Override
        public boolean _hasNext() {
            return this.currentRow != null;
        }

        @Override
        public Row _next() {
            Row ret = this.currentRow;
            this.currentRow = this.nextRow();
            return ret;
        }

        @Override
        public void remove() {
        }
    }
}

