/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.input;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.AlgoException;
import kd.bos.algo.InputExecutor;
import kd.bos.algo.Row;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.util.concurrent.AlgoExecutors;
import kd.bos.thread.ThreadLifeCycleManager;

public class ParallelInputExecutorsRowIterator
extends InnerRowIterator
implements Closeable {
    private InputExecutor[] executors;
    private LinkedBlockingQueue<InputExecutor> jobs = new LinkedBlockingQueue();
    private LinkedBlockingQueue<List<Row>> rowQueue = new LinkedBlockingQueue(4);
    private Throwable error;
    private boolean eof;
    private boolean closed;
    private boolean started = false;
    private AtomicInteger threadCount;
    private CountDownLatch startLatch;
    private int parallelism = AlgoConfiguration.PARALLELINPUT_PARRALLELISM.getInt();
    private int bufferSize = AlgoConfiguration.PARALLELINPUT_BUFFERSIZE.getInt();
    private static ExecutorService es = AlgoExecutors.newCachedThreadPool(AlgoConfiguration.PARALLELINPUT_THREADPOOL_CORESIZE.getInt(), AlgoConfiguration.PARALLELINPUT_THREADPOOL_MAXSIZE.getInt(), "Input");
    private List<Row> rowList = null;
    private Iterator<Row> rowIterator = null;

    public ParallelInputExecutorsRowIterator(InputExecutor[] executors) {
        this.executors = executors;
        this.init();
    }

    private void init() {
        for (InputExecutor executor : this.executors) {
            this.jobs.add(executor);
        }
        int parall = this.executors.length > this.parallelism ? this.parallelism : this.executors.length;
        this.threadCount = new AtomicInteger(parall);
        this.startLatch = new CountDownLatch(parall);
        for (int i = 0; i < parall; ++i) {
            Runnable r = new MyRunnable();
            if (AlgoConfiguration.INPUT_RUNNABLE_WRAP.getBoolean()) {
                r = ThreadLifeCycleManager.wrapRunnable((Runnable)r);
            }
            try {
                es.execute(r);
                continue;
            }
            catch (RuntimeException e) {
                this.error = new AlgoException(e, "Can't allocate enough threads in pool.", new Object[0]);
                break;
            }
        }
    }

    @Override
    protected boolean _hasNext() {
        if (this.error != null) {
            throw AlgoException.wrap(this.error);
        }
        if (!this.started) {
            try {
                this.startLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.started = true;
        }
        if (this.rowIterator != null) {
            if (this.rowIterator.hasNext()) {
                return true;
            }
            this.rowIterator = null;
        }
        while (true) {
            if (this.error != null) {
                throw AlgoException.wrap(this.error);
            }
            if (this.closed) {
                return false;
            }
            if (this.eof) {
                this.rowList = this.rowQueue.poll();
                if (this.rowList != null) {
                    this.rowIterator = this.rowList.iterator();
                }
                return this.rowIterator != null;
            }
            try {
                this.rowList = this.rowQueue.poll(1L, TimeUnit.MILLISECONDS);
                if (this.rowList == null) continue;
                this.rowIterator = this.rowList.iterator();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @Override
    protected Row _next() {
        if (this.error != null) {
            throw AlgoException.wrap(this.error);
        }
        return this.rowIterator.next();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    class MyRunnable
    implements Runnable {
        MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count;
            InputExecutor executor;
            ParallelInputExecutorsRowIterator.this.startLatch.countDown();
            block13: while (!ParallelInputExecutorsRowIterator.this.closed && !ParallelInputExecutorsRowIterator.this.eof && ParallelInputExecutorsRowIterator.this.error == null && (executor = (InputExecutor)ParallelInputExecutorsRowIterator.this.jobs.poll()) != null) {
                try {
                    executor.open();
                    while (!ParallelInputExecutorsRowIterator.this.closed && ParallelInputExecutorsRowIterator.this.error == null && !Thread.currentThread().isInterrupted()) {
                        int i = 0;
                        ArrayList<Row> buffer = new ArrayList<Row>();
                        while (i++ < ParallelInputExecutorsRowIterator.this.bufferSize && executor.hasNext()) {
                            buffer.add(executor.next());
                        }
                        try {
                            if (buffer.size() <= 0) continue block13;
                            while (!ParallelInputExecutorsRowIterator.this.closed && ParallelInputExecutorsRowIterator.this.error == null && !Thread.currentThread().isInterrupted()) {
                                if (!ParallelInputExecutorsRowIterator.this.rowQueue.offer(buffer, 5L, TimeUnit.SECONDS)) continue;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (Throwable t) {
                    ParallelInputExecutorsRowIterator.this.error = t;
                    break;
                }
                finally {
                    try {
                        executor.close();
                    }
                    catch (Throwable i) {}
                }
            }
            if ((count = ParallelInputExecutorsRowIterator.this.threadCount.decrementAndGet()) == 0) {
                ParallelInputExecutorsRowIterator.this.eof = true;
            }
        }
    }
}

