/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.join.JoinRow;
import kd.bos.algo.dataset.order.OrderComparator;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.util.Tuple2;

public abstract class AbstractJoinDataSet
extends AbstractDataSet {
    protected JoinDataSetBuilder builder;
    protected Comparator<Row> leftComparator;
    protected Comparator<Row> rightComparator;
    protected OrderItem[] leftOrderItems;
    protected OrderItem[] rightOrderItems;
    protected Comparator<Row> comparator;
    private Calc[] leftCalcs;
    private Calc[] rightCalcs;
    protected InnerRowIterator resultIterator;

    public AbstractJoinDataSet(String name, AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super(name, leftDataSet.getEnvironment(), Lists.newArrayList((Object[])new AbstractDataSet[]{leftDataSet, rightDataSet}));
        this.builder = builder;
        this.buildMeta();
    }

    @Override
    protected InnerRowIterator createIterator() {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
        this.resultIterator = this.createIterator0();
        return this.resultIterator;
    }

    protected abstract InnerRowIterator createIterator0();

    protected AbstractDataSet getLeftDataSet() {
        return this.getInput(0);
    }

    protected AbstractDataSet getRightDataSet() {
        return this.getInput(1);
    }

    protected int[] getLeftJoinOnColumns() {
        AbstractDataSet dataset = this.getLeftDataSet();
        RowMeta rowMeta = dataset.getRowMeta();
        List<Tuple2<String, String>> list = this.builder.getOnList();
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            int index;
            String field = (String)list.get((int)i).t1;
            result[i] = index = rowMeta.getFieldIndex(field);
        }
        return result;
    }

    protected int[] getRightJoinOnColumns() {
        AbstractDataSet dataset = this.getRightDataSet();
        RowMeta rowMeta = dataset.getRowMeta();
        List<Tuple2<String, String>> list = this.builder.getOnList();
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            int index;
            String field = (String)list.get((int)i).t2;
            result[i] = index = rowMeta.getFieldIndex(field);
        }
        return result;
    }

    public OrderItem[] getLeftOrderItems() {
        return this.leftOrderItems;
    }

    public OrderItem[] getRightOrderItems() {
        return this.rightOrderItems;
    }

    private void buildMeta() {
        Field field;
        Alias aliasExpr;
        Expr expr;
        String s;
        int i;
        List<Tuple2<String, String>> onList = this.builder.getOnList();
        AbstractDataSet leftDataSet = this.getInput(0);
        AbstractDataSet rightDataSet = this.getInput(1);
        String[] leftFields = this.builder.getLeftFields();
        String[] rightFields = this.builder.getRightFields();
        if (rightFields == null) {
            rightFields = new String[]{};
        }
        String[] leftJoinFields = new String[onList.size()];
        String[] rightJoinFields = new String[onList.size()];
        this.leftOrderItems = new OrderItem[onList.size()];
        this.rightOrderItems = new OrderItem[onList.size()];
        for (int i2 = 0; i2 < onList.size(); ++i2) {
            Tuple2<String, String> tuple = onList.get(i2);
            leftJoinFields[i2] = (String)tuple.t1;
            rightJoinFields[i2] = (String)tuple.t2;
            this.leftOrderItems[i2] = new OrderItem((String)tuple.t1, true);
            this.rightOrderItems[i2] = new OrderItem((String)tuple.t2, true);
        }
        RowMeta leftRowMeta = leftDataSet.getRowMeta();
        RowMeta rightRowMeta = rightDataSet.getRowMeta();
        this.leftComparator = new OrderComparator(leftRowMeta, this.leftOrderItems);
        this.rightComparator = new OrderComparator(rightRowMeta, this.rightOrderItems);
        this.comparator = new OrderComparator(leftRowMeta, this.leftOrderItems, rightRowMeta, this.rightOrderItems, this.builder.getJoinHint());
        ArrayList<Field> targetFields = new ArrayList<Field>();
        HashSet<String> duplicate = new HashSet<String>();
        this.leftCalcs = new Calc[leftFields.length];
        this.rightCalcs = new Calc[rightFields.length];
        ExprParser leftParser = new ExprParser(leftRowMeta, rightRowMeta, false);
        ExprParser rightParser = new ExprParser(leftRowMeta, rightRowMeta, true);
        CompileContext cc = new CompileContext(leftRowMeta);
        for (i = 0; i < leftFields.length; ++i) {
            s = leftFields[i];
            expr = leftParser.parse(s);
            aliasExpr = leftParser.transformAlias(expr);
            if (!duplicate.add(aliasExpr.getAlias())) {
                throw new AlgoException("Duplicated fields :" + aliasExpr.getAlias());
            }
            field = new Field(aliasExpr.getAlias(), aliasExpr.getDataType());
            targetFields.add(field);
            this.leftCalcs[i] = expr.compile(cc);
        }
        cc = new CompileContext(rightRowMeta);
        for (i = 0; i < rightFields.length; ++i) {
            s = rightFields[i];
            expr = rightParser.parse(s);
            aliasExpr = rightParser.transformAlias(expr);
            if (!duplicate.add(aliasExpr.getAlias())) {
                throw new AlgoException("Duplicated fields :" + aliasExpr.getAlias());
            }
            field = new Field(aliasExpr.getAlias(), aliasExpr.getDataType());
            targetFields.add(field);
            this.rightCalcs[i] = expr.compile(cc);
        }
        this.rowMeta = new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    protected Row makeTargetRow(Row leftRow, Row rightRow) {
        return new JoinRow(this.rowMeta, this.leftCalcs, this.rightCalcs, (AbstractRow)leftRow, (AbstractRow)rightRow);
    }

    protected Row makeTargetRowX(Row rightRow, Row leftRow) {
        return new JoinRow(this.rowMeta, this.leftCalcs, this.rightCalcs, (AbstractRow)leftRow, (AbstractRow)rightRow);
    }

    @Override
    public void realClose() {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
    }

    protected AbstractRow persistRow(Row row) {
        if (row == null) {
            return null;
        }
        return ((AbstractRow)row).persist();
    }
}

