/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.join.InnerJoinDataSet;
import kd.bos.algo.dataset.join.JvmCrossJoinDataSet;
import kd.bos.algo.dataset.join.NotInnerJoinDataSet;
import kd.bos.algo.util.Tuple2;

public class JoinDataSetBuilder
implements JoinDataSet {
    private transient AbstractDataSet leftDataSet;
    private transient AbstractDataSet rightDataSet;
    private JoinType joinType;
    private ArrayList<Tuple2<String, String>> onList = new ArrayList();
    private String[] leftFields;
    private String[] rightFields;
    private JoinHint hint;

    public JoinDataSetBuilder(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinType joinType, JoinHint hint) {
        leftDataSet.checkClosed();
        rightDataSet.checkClosed();
        this.leftDataSet = leftDataSet;
        this.rightDataSet = rightDataSet;
        this.joinType = joinType;
        this.hint = hint;
    }

    @Override
    public JoinDataSet on(String leftField, String rightField) {
        DataType dataType2;
        Field lf = this.leftDataSet.getRowMeta().getField(leftField);
        Field rf = this.rightDataSet.getRowMeta().getField(rightField);
        DataType dataType1 = lf.getDataType();
        if (!dataType1.acceptsType(dataType2 = rf.getDataType())) {
            throw new AlgoException(String.format("Join on %s(%s) not same with %s(%s).", leftField, dataType1.getName(), rightField, dataType2.getName()));
        }
        this.onList.add(new Tuple2<String, String>(leftField, rightField));
        return this;
    }

    @Override
    public JoinDataSet select(String[] leftFields, String[] rightFields) {
        this.leftFields = leftFields;
        this.rightFields = rightFields;
        return this;
    }

    @Override
    public JoinDataSet select(String ... fields) {
        this.leftFields = fields;
        return this;
    }

    @Override
    public JoinDataSet hint(JoinHint hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public DataSet finish() {
        try {
            if (this.joinType == JoinType.CROSS) {
                JvmCrossJoinDataSet jvmCrossJoinDataSet = new JvmCrossJoinDataSet(this.leftDataSet, this.rightDataSet, this);
                return jvmCrossJoinDataSet;
            }
            if (this.onList.isEmpty()) {
                throw new AlgoException("on clause can't be null, please invoke on() before finish()");
            }
            if (this.leftFields == null && this.rightFields == null) {
                throw new AlgoException("leftFields and rightFields can't be null, please invoke select() before finish()");
            }
            if (JoinType.INNER == this.joinType) {
                InnerJoinDataSet innerJoinDataSet = new InnerJoinDataSet(this.leftDataSet, this.rightDataSet, this);
                return innerJoinDataSet;
            }
            NotInnerJoinDataSet notInnerJoinDataSet = new NotInnerJoinDataSet(this.leftDataSet, this.rightDataSet, this);
            return notInnerJoinDataSet;
        }
        finally {
            this.leftDataSet = null;
            this.rightDataSet = null;
        }
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public List<Tuple2<String, String>> getOnList() {
        return this.onList;
    }

    public String[] getLeftFields() {
        return this.leftFields;
    }

    public String[] getRightFields() {
        return this.rightFields;
    }

    public JoinHint getJoinHint() {
        return this.hint;
    }
}

