/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.join.CrossJoinRow;
import kd.bos.algo.dataset.join.JoinDataSetBuilder;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;

public class JvmCrossJoinDataSet
extends AbstractDataSet {
    private JoinDataSetBuilder builder;
    private Calc[] leftCalcs;
    private Calc[] rightCalcs;
    private Store rightStore;

    public JvmCrossJoinDataSet(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet, JoinDataSetBuilder builder) {
        super("CrossJoin", leftDataSet.getEnvironment(), Lists.newArrayList((Object[])new AbstractDataSet[]{leftDataSet, rightDataSet}));
        this.builder = builder;
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        Field field;
        Alias aliasExpr;
        Expr expr;
        String s;
        int i;
        String[] leftFields = this.builder.getLeftFields();
        String[] rightFields = this.builder.getRightFields();
        if (rightFields == null) {
            rightFields = new String[]{};
        }
        ArrayList<Field> targetFields = new ArrayList<Field>();
        HashSet<String> duplicate = new HashSet<String>();
        AbstractDataSet leftDataSet = this.getInput(0);
        AbstractDataSet rightDataSet = this.getInput(1);
        RowMeta leftRowMeta = leftDataSet.getRowMeta();
        RowMeta rightRowMeta = rightDataSet.getRowMeta();
        this.leftCalcs = new Calc[leftFields.length];
        this.rightCalcs = new Calc[rightFields.length];
        ExprParser parser = new ExprParser(leftRowMeta);
        CompileContext cc = new CompileContext(leftRowMeta);
        for (i = 0; i < leftFields.length; ++i) {
            s = leftFields[i];
            expr = parser.parse(s);
            aliasExpr = parser.transformAlias(expr);
            if (!duplicate.add(aliasExpr.getAlias())) {
                throw new AlgoException("Duplicated fields :" + aliasExpr.getAlias());
            }
            field = new Field(aliasExpr.getAlias(), aliasExpr.getDataType());
            targetFields.add(field);
            this.leftCalcs[i] = expr.compile(cc);
        }
        parser = new ExprParser(rightRowMeta);
        cc = new CompileContext(rightRowMeta);
        for (i = 0; i < rightFields.length; ++i) {
            s = rightFields[i];
            expr = parser.parse(s);
            aliasExpr = parser.transformAlias(expr);
            if (!duplicate.add(aliasExpr.getAlias())) {
                throw new AlgoException("Ambulous fields :" + aliasExpr.getAlias());
            }
            field = new Field(aliasExpr.getAlias(), aliasExpr.getDataType());
            targetFields.add(field);
            this.rightCalcs[i] = expr.compile(cc);
        }
        return new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        return this._createIterator();
    }

    protected InnerRowIterator _createIterator() {
        AbstractDataSet leftDataSet = this.getInput(0);
        AbstractDataSet rightDataSet = this.getInput(1);
        return new MyIterator(leftDataSet, rightDataSet);
    }

    protected Row makeTargetRow(Row leftRow, Row rightRow) {
        return new CrossJoinRow(this.rowMeta, this.leftCalcs, this.rightCalcs, (AbstractRow)leftRow, (AbstractRow)rightRow);
    }

    @Override
    public void realClose() {
        if (this.rightStore != null) {
            this.rightStore.close();
        }
    }

    public class MyIterator
    extends InnerRowIterator {
        private Iterator<Row> leftIter;
        private Iterator<Row> rightIter;
        private Row leftRow;
        private boolean empty = false;

        public MyIterator(AbstractDataSet leftDataSet, AbstractDataSet rightDataSet) {
            this.leftIter = leftDataSet.innerIterator();
            if (!this.leftIter.hasNext()) {
                this.empty = true;
                return;
            }
            JvmCrossJoinDataSet.this.rightStore = StoreFactory.createDataSetBackStore(rightDataSet.getRowMeta());
            JvmCrossJoinDataSet.this.rightStore.write(rightDataSet.innerIterator());
            Store store = JvmCrossJoinDataSet.this.rightStore;
            this.rightIter = store.getRowIterator();
            if (!this.rightIter.hasNext()) {
                this.empty = true;
                return;
            }
            this.leftRow = this.leftIter.next();
        }

        @Override
        public boolean _hasNext() {
            if (this.empty) {
                return false;
            }
            if (this.rightIter.hasNext()) {
                return true;
            }
            return this.leftIter.hasNext();
        }

        @Override
        public Row _next() {
            if (this.empty) {
                return null;
            }
            if (this.rightIter.hasNext()) {
                Row rightRow = this.rightIter.next();
                return JvmCrossJoinDataSet.this.makeTargetRow(this.leftRow, rightRow);
            }
            if (this.leftIter.hasNext()) {
                this.leftRow = this.leftIter.next();
                this.rightIter = JvmCrossJoinDataSet.this.rightStore.getRowIterator();
                Row rightRow = this.rightIter.next();
                return JvmCrossJoinDataSet.this.makeTargetRow(this.leftRow, rightRow);
            }
            return null;
        }
    }
}

