/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.join;

import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.MultiValueMapStore;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.util.ArrayKey;

public class NestInnerIndex {
    private MultiValueMapStore<Object, Row> mapStore;
    private int[] columns;

    public NestInnerIndex(int[] columns) {
        this.columns = columns;
    }

    private void createMapStore(RowMeta rowMeta) {
        this.mapStore = StoreFactory.createMultiValueMapStore(rowMeta.getFieldCount());
    }

    public void build(Store originStore) {
        Store store = originStore.copy();
        this.createMapStore(store.getRowMeta());
        Iterator<Row> iter = store.getRowIterator();
        while (iter.hasNext()) {
            Row row = iter.next();
            Object keys = this.getKeys(row);
            if (keys instanceof Object[]) {
                keys = new ArrayKey((Object[])keys);
            }
            this.mapStore.put(keys, row);
        }
        store.close();
    }

    public Iterator<Row> get(Object key) {
        List<Row> list;
        if (key instanceof Object[]) {
            key = new ArrayKey((Object[])key);
        }
        return (list = this.mapStore.get(key)) == null ? null : list.iterator();
    }

    private Object getKeys(Row row) {
        Object[] keys = new Object[this.columns.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = row.get(this.columns[i]);
        }
        return keys.length > 1 ? keys : keys[0];
    }

    public Iterator<Object> keyIter() {
        return this.mapStore.keyIterator();
    }

    public void close() {
        if (this.mapStore != null) {
            this.mapStore.close();
        }
    }
}

