/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.map;

import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.SettableArrayRow;

public class MapDataSet
extends AbstractDataSet {
    private MapFunction fun;
    private RowMeta rowMeta;
    private SettableArrayRow sar;

    public MapDataSet(AbstractDataSet dataSet, MapFunction fun) {
        super("Map", dataSet);
        this.fun = fun;
        this.rowMeta = fun.getResultRowMeta();
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    protected InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet inner = this.getInput(0);
        final InnerRowIterator iter = inner.innerIterator();
        return new InnerRowIterator(){

            @Override
            protected boolean _hasNext() {
                return iter.hasNext();
            }

            @Override
            protected Row _next() {
                Object[] values = MapDataSet.this.fun.map((Row)iter.next());
                return MapDataSet.this.getRow(values);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Row getRow(Object[] values) {
        if (this.sar == null) {
            this.sar = new SettableArrayRow(this.rowMeta, values, false);
        } else {
            this.sar.setValues(values);
        }
        return this.sar;
    }

    @Override
    public void realClose() {
    }
}

