/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.order;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.order.OrderComparator;
import kd.bos.algo.dataset.store.sort.FixedPriorityQueue;

public class TopOrderDataSet
extends AbstractDataSet {
    private DataSet topDataSet;
    private OrderItem[] orderItems;
    private String[] exprs;
    private final int top;

    public TopOrderDataSet(AbstractDataSet child, int top, String[] exprs) {
        this(child, top, exprs, null);
    }

    public TopOrderDataSet(AbstractDataSet child, int top, String[] exprs, boolean[] descs) {
        super("Order", child);
        this.exprs = exprs;
        this.orderItems = TopOrderDataSet.buildOrderItems(exprs, descs);
        this.rowMeta = child.getRowMeta();
        this.top = top;
    }

    private static OrderItem[] buildOrderItems(String[] exprs, boolean[] descs) {
        OrderItem[] orderItems = new OrderItem[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            String[] parts = exprs[i].trim().split(" ");
            String sortExpr = parts[0];
            boolean asc = parts.length > 1 ? "asc".equalsIgnoreCase(parts[1]) : (descs == null ? true : !descs[i]);
            orderItems[i] = new OrderItem(sortExpr, asc);
        }
        return orderItems;
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet input = this.getInput(0);
        if (this.top >= AlgoConfiguration.TOPBY_ORDERTOP_THRESHOLD.getInt()) {
            return this.traditionalIterator(input);
        }
        return this.immediateIterator(input);
    }

    private InnerRowIterator traditionalIterator(AbstractDataSet input) {
        DataSet orderByDataSet = input.orderBy(this.exprs);
        this.topDataSet = orderByDataSet.top(this.top);
        return InnerRowIterator.wrapper(this.topDataSet);
    }

    private InnerRowIterator immediateIterator(AbstractDataSet input) {
        FixedPriorityQueue<Row> priorityQueue = new FixedPriorityQueue<Row>(this.top, new OrderComparator(this.rowMeta, this.orderItems));
        InnerRowIterator iterator = input.innerIterator();
        while (iterator.hasNext()) {
            priorityQueue.add(((AbstractRow)iterator.next()).persist());
        }
        return InnerRowIterator.wrapper(priorityQueue.iterator());
    }

    @Override
    public void realClose() {
        if (this.topDataSet != null) {
            this.topDataSet.close();
        }
    }
}

