/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.schema;

import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.schema.CommonColumn;
import kd.bos.algo.sql.schema.Column;
import kd.bos.algo.sql.schema.Schema;
import kd.bos.algo.sql.schema.Table;

public class DataSetTable
implements Table {
    private RowMeta meta;
    private String name;
    private Schema schema;

    public DataSetTable(Schema schema, RowMeta meta, String name) {
        this.meta = meta;
        this.name = name;
        this.schema = schema;
    }

    private String makeKey(String key) {
        return this.schema.isIgnoreCase() ? key.toUpperCase() : key;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Column[] getColumns() {
        int size = this.meta.getFieldCount();
        Column[] columns = new Column[size];
        for (int i = 0; i < size; ++i) {
            columns[i] = new CommonColumn(this, this.meta.getField(i), i);
        }
        return columns;
    }

    @Override
    public Column lookupColumn(String name) {
        int index = this.meta.getFieldIndex(name, false);
        if (index < 0) {
            return null;
        }
        Field field = this.meta.getField(index);
        return new CommonColumn(this, field, index);
    }
}

