/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.util.ArrayKey;

public class DistinctDataSet
extends AbstractDataSet {
    private RowMeta rowMeta;
    private DataSet orderDataSet;

    public DistinctDataSet(AbstractDataSet dataSet) {
        super("Distinct", dataSet);
        this.rowMeta = dataSet.getRowMeta();
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    protected InnerRowIterator createIterator() {
        AbstractDataSet dataSet = this.getInput(0);
        this.orderDataSet = dataSet.orderBy(this.rowMeta.getFieldNames());
        return new MyIter(this.orderDataSet.iterator());
    }

    @Override
    public void realClose() {
        if (this.orderDataSet != null) {
            this.orderDataSet.close();
        }
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> iter;
        private Row nextRow;
        private boolean hasNexted = false;
        private boolean eof = false;
        private ArrayKey tempArrKey;

        public MyIter(Iterator<Row> iter) {
            this.iter = iter;
        }

        @Override
        public boolean _hasNext() {
            if (!this.hasNexted) {
                this.doNext();
            }
            return !this.eof;
        }

        @Override
        public Row _next() {
            this.hasNexted = false;
            return this.nextRow;
        }

        private ArrayKey toKey(Row row) {
            Object[] keys = new Object[DistinctDataSet.this.rowMeta.getFieldCount()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = row.get(i);
            }
            return new ArrayKey(keys);
        }

        private void doNext() {
            block2: {
                Row row;
                ArrayKey arrayKey;
                this.hasNexted = true;
                if (this.eof) {
                    return;
                }
                do {
                    if (this.iter.hasNext()) continue;
                    this.eof = true;
                    break block2;
                } while ((arrayKey = this.toKey(row = this.iter.next())).equals(this.tempArrKey));
                this.tempArrKey = arrayKey;
                this.nextRow = row;
            }
        }
    }
}

