/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.MappedSelectRow;

public class RemoveFieldsDataSet
extends AbstractDataSet {
    private String[] removeFields;
    private Map<String, Integer> fieldIndexMap = new HashMap<String, Integer>(4);
    private int[] fieldIndexIntMapper = null;

    public RemoveFieldsDataSet(AbstractDataSet dataSet, String[] fields) {
        super("Remove", dataSet);
        this.removeFields = fields;
        this.fieldIndexIntMapper = new int[dataSet.getRowMeta().getFieldCount() - fields.length];
        this.rowMeta = this.createTargetRowMeta();
    }

    @Override
    public final RowMeta createTargetRowMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta rowMeta = dataSet.getRowMeta();
        ArrayList<Field> targetFields = new ArrayList<Field>();
        HashSet<String> set = new HashSet<String>();
        for (String alias : this.removeFields) {
            set.add(alias.toLowerCase());
        }
        int intIndexPos = 0;
        for (int i = 0; i < rowMeta.getFieldCount(); ++i) {
            Field field = rowMeta.getField(i);
            if (set.contains(field.getAlias().toLowerCase())) continue;
            targetFields.add(field);
            this.fieldIndexMap.put(field.getAlias(), i);
            this.fieldIndexIntMapper[intIndexPos++] = i;
        }
        return new RowMeta(targetFields.toArray(new Field[targetFields.size()]));
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        final InnerRowIterator iter = dataSet.innerIterator();
        final MappedSelectRow cursor = new MappedSelectRow(this.getRowMeta(), this.fieldIndexMap, this.fieldIndexIntMapper);
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                return iter.hasNext();
            }

            @Override
            public Row _next() {
                Row row = (Row)iter.next();
                cursor.setRow(row);
                return cursor;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void realClose() {
    }
}

