/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.dataset.select.ReferenceDataSet;
import kd.bos.algo.dataset.select.SelectDataSetWithDistinct;
import kd.bos.algo.dataset.select.SimpleSelectDataSetWithDistinct;
import kd.bos.algo.sql.resolve.ColumnAliasTransformer;
import kd.bos.algo.sql.resolve.TraverResolver;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.ExprList;
import kd.bos.algo.sql.tree.PreRowValueExpr;
import kd.bos.algo.sql.tree.PreRowValueSelfExpr;
import kd.bos.algo.sql.tree.bind.ColumnRef;

public class SelectBuilderWithDistinct {
    public static DataSet build(AbstractDataSet dataSet, String[] exprs) {
        RowMeta rowMeta = dataSet.getRowMeta();
        if (rowMeta.getFieldCount() == exprs.length && SelectBuilderWithDistinct.allSame(rowMeta, exprs)) {
            return new ReferenceDataSet(dataSet);
        }
        ExprParser executor = new ExprParser(rowMeta);
        Expr[] exs = new Expr[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            exs[i] = executor.parse(exprs[i]);
        }
        return SelectBuilderWithDistinct.build(dataSet, exs);
    }

    private static boolean allSame(RowMeta rowMeta, String[] exprs) {
        for (int i = 0; i < exprs.length; ++i) {
            if (rowMeta.getField(i).getAlias().equalsIgnoreCase(exprs[i])) continue;
            return false;
        }
        return true;
    }

    public static DataSet build(AbstractDataSet dataSet, String expr) {
        Expr[] exprs;
        RowMeta rowMeta = dataSet.getRowMeta();
        ExprParser executor = new ExprParser(rowMeta);
        Expr ex = executor.parse(expr);
        if (ex instanceof ExprList) {
            ExprList el = (ExprList)ex;
            exprs = el.getChildren().toArray(new Expr[0]);
        } else {
            exprs = new Expr[]{ex};
        }
        return SelectBuilderWithDistinct.build(dataSet, exprs);
    }

    private static DataSet build(AbstractDataSet dataSet, Expr[] exprs) {
        Field[] targetFields = new Field[exprs.length];
        String[] fieldRefs = new String[exprs.length];
        Alias[] newExprs = new Alias[exprs.length];
        boolean hasExpr = false;
        boolean hasPreRowValueExpr = false;
        for (int i = 0; i < exprs.length; ++i) {
            Expr child;
            Expr ex = exprs[i];
            newExprs[i] = (Alias)ex.resolve(ColumnAliasTransformer.instance);
            PreRowValueResolver resolver = new PreRowValueResolver(newExprs[i].getAlias(), i);
            newExprs[i].resolve(resolver);
            if (resolver.hasPreRowValueExpr) {
                hasPreRowValueExpr = true;
            }
            if ((child = newExprs[i].getChild()) instanceof ColumnRef) {
                fieldRefs[i] = ((ColumnRef)child).getName();
            } else {
                hasExpr = true;
            }
            DataType dataType = ex.getDataType();
            targetFields[i] = new Field(newExprs[i].getAlias(), dataType);
        }
        if (hasPreRowValueExpr) {
            return new SelectDataSetWithDistinct(dataSet, newExprs, true);
        }
        if (hasExpr) {
            return new SelectDataSetWithDistinct(dataSet, newExprs, false);
        }
        return new SimpleSelectDataSetWithDistinct(dataSet, fieldRefs, targetFields);
    }

    static class PreRowValueResolver
    extends TraverResolver {
        private boolean hasPreRowValueExpr;
        private String alias;
        private int fieldIndex;

        public PreRowValueResolver(String alias, int fieldIndex) {
            this.alias = alias;
            this.fieldIndex = fieldIndex;
        }

        @Override
        protected Expr resolveSelf(Expr expr) {
            if (expr instanceof PreRowValueExpr) {
                this.hasPreRowValueExpr = true;
            } else if (expr instanceof PreRowValueSelfExpr) {
                this.hasPreRowValueExpr = true;
                ((PreRowValueSelfExpr)expr).setFieldName(this.alias);
                ((PreRowValueSelfExpr)expr).setFieldIndex(this.fieldIndex);
            }
            return expr;
        }
    }
}

