/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.SettableArrayRow;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.calc.Calc;
import kd.bos.algo.sql.tree.calc.CompileContext;
import kd.bos.algo.util.ArrayKey;

public class SelectDataSetWithDistinct
extends AbstractDataSet {
    private Alias[] exprs;
    private boolean hasPreRowExpr;
    private Calc[] calcs;
    private SettableArrayRow cacheRow;
    private OrderItem[] orderItems;
    private Store orderStore;

    public SelectDataSetWithDistinct(AbstractDataSet dataSet, Alias[] exprs, boolean hasPreRowExpr) {
        super("Select", dataSet);
        this.exprs = exprs;
        this.hasPreRowExpr = hasPreRowExpr;
        this.rowMeta = this.createTargetRowMeta();
    }

    private RowMeta buildRowMeta() {
        AbstractDataSet dataSet = this.getInput(0);
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] targetFields = new Field[this.exprs.length];
        this.orderItems = new OrderItem[this.exprs.length];
        for (int i = 0; i < this.exprs.length; ++i) {
            DataType dataType = this.exprs[i].getDataType();
            targetFields[i] = new Field(this.exprs[i].getAlias(), dataType);
            this.orderItems[i] = new OrderItem(this.exprs[i].getAlias());
        }
        this.checkDuplicateName(targetFields);
        RowMeta result = new RowMeta(targetFields);
        CompileContext cc = new CompileContext(rowMeta, result);
        this.calcs = new Calc[this.exprs.length];
        for (int i = 0; i < this.exprs.length; ++i) {
            this.calcs[i] = this.exprs[i].compile(cc);
        }
        return result;
    }

    private void checkDuplicateName(Field[] targetFields) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < targetFields.length; ++i) {
            if (set.add(targetFields[i].getAlias())) continue;
            throw new AlgoException("Duplicated field: " + targetFields[i].getAlias());
        }
    }

    @Override
    public final RowMeta createTargetRowMeta() {
        return this.buildRowMeta();
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        this.orderStore = StoreFactory.createOrderStore(this.rowMeta, this.orderItems);
        this.orderStore.write(dataSet.innerIterator());
        this.detachInputs(true);
        this.cacheRow = new SettableArrayRow(this.rowMeta);
        return new MyIter(this.orderStore.getRowIterator());
    }

    @Override
    public void realClose() {
        if (this.orderStore != null) {
            this.orderStore.close();
        }
    }

    private Row convertRow(SettableArrayRow row, Calc[] calcs, Row innerRow, Row preRow) {
        for (int i = 0; i < calcs.length; ++i) {
            row.setValue(i, calcs[i].execute(innerRow, preRow));
        }
        return row;
    }

    static /* synthetic */ RowMeta access$000(SelectDataSetWithDistinct x0) {
        return x0.rowMeta;
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> iter;
        private Row nextRow;
        private boolean hasNexted = false;
        private boolean eof = false;
        private ArrayKey tempArrKey;
        final SettableArrayRow preRow = new SettableArrayRow(SelectDataSetWithDistinct.access$000(SelectDataSetWithDistinct.this));

        public MyIter(Iterator<Row> iter) {
            this.iter = iter;
        }

        @Override
        public boolean _hasNext() {
            if (!this.hasNexted) {
                this.doNext();
            }
            return !this.eof;
        }

        @Override
        public Row _next() {
            this.hasNexted = false;
            return this.nextRow;
        }

        private ArrayKey toKey(Row row) {
            Object[] keys = new Object[SelectDataSetWithDistinct.this.rowMeta.getFieldCount()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = row.get(i);
            }
            return new ArrayKey(keys);
        }

        private void doNext() {
            block4: {
                ArrayKey arrayKey;
                Row result;
                this.hasNexted = true;
                if (this.eof) {
                    return;
                }
                do {
                    if (!this.iter.hasNext()) {
                        this.eof = true;
                        break block4;
                    }
                    result = SelectDataSetWithDistinct.this.convertRow(SelectDataSetWithDistinct.this.cacheRow, SelectDataSetWithDistinct.this.calcs, this.iter.next(), SelectDataSetWithDistinct.this.hasPreRowExpr ? this.preRow : null);
                    if (!SelectDataSetWithDistinct.this.hasPreRowExpr) continue;
                    for (int i = 0; i < SelectDataSetWithDistinct.this.cacheRow.size(); ++i) {
                        this.preRow.setValue(i, SelectDataSetWithDistinct.this.cacheRow.get(i));
                    }
                } while (result == null || (arrayKey = this.toKey(result)).equals(this.tempArrKey));
                this.tempArrKey = arrayKey;
                this.nextRow = result;
            }
        }
    }
}

