/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.select;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.MappedSelectRow;
import kd.bos.algo.util.ArrayKey;

public class SimpleSelectDataSetWithDistinct
extends AbstractDataSet {
    private Map<String, Integer> fieldIndexMapper = new HashMap<String, Integer>(4);
    private int[] fieldIndexIntMapper = null;
    private String[] orderFields;
    private DataSet orderDataSet = null;

    public SimpleSelectDataSetWithDistinct(AbstractDataSet dataSet, String[] fieldRefs, Field[] targetFields) {
        super("SimpleSelect", dataSet);
        this.checkDuplicateName(targetFields);
        this.rowMeta = new RowMeta(targetFields);
        RowMeta rm = dataSet.getRowMeta();
        this.orderFields = new String[targetFields.length];
        this.fieldIndexIntMapper = new int[fieldRefs.length];
        for (int i = 0; i < fieldRefs.length; ++i) {
            int index;
            this.orderFields[i] = targetFields[i].getAlias();
            Field field = targetFields[i];
            String alias = field.getAlias();
            this.fieldIndexIntMapper[i] = index = rm.getFieldIndex(fieldRefs[i]);
            this.fieldIndexMapper.put(alias, index);
        }
    }

    @Override
    public RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    private void checkDuplicateName(Field[] targetFields) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < targetFields.length; ++i) {
            if (set.add(targetFields[i].getAlias())) continue;
            throw new AlgoException("Duplicated field alias: " + targetFields[i].getAlias());
        }
    }

    @Override
    public InnerRowIterator createIterator() {
        this.checkClosed();
        AbstractDataSet dataSet = this.getInput(0);
        this.orderDataSet = dataSet.orderBy(this.orderFields);
        return new MyIter(this.orderDataSet.iterator());
    }

    @Override
    public void realClose() {
        if (this.orderDataSet != null) {
            this.orderDataSet.close();
        }
    }

    class MyIter
    extends InnerRowIterator {
        private Iterator<Row> iter;
        private Row nextRow;
        private boolean hasNexted = false;
        private boolean eof = false;
        private ArrayKey tempArrKey;
        private MappedSelectRow cursor;

        public MyIter(Iterator<Row> iter) {
            this.iter = iter;
            this.cursor = new MappedSelectRow(SimpleSelectDataSetWithDistinct.this.getRowMeta(), SimpleSelectDataSetWithDistinct.this.fieldIndexMapper, SimpleSelectDataSetWithDistinct.this.fieldIndexIntMapper);
        }

        @Override
        public boolean _hasNext() {
            if (!this.hasNexted) {
                this.doNext();
            }
            return !this.eof;
        }

        @Override
        public Row _next() {
            this.hasNexted = false;
            return this.nextRow;
        }

        private ArrayKey toKey(Row row) {
            Object[] keys = new Object[SimpleSelectDataSetWithDistinct.this.rowMeta.getFieldCount()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = row.get(i);
            }
            return new ArrayKey(keys);
        }

        private void doNext() {
            block3: {
                ArrayKey arrayKey;
                this.hasNexted = true;
                if (this.eof) {
                    return;
                }
                do {
                    if (!this.iter.hasNext()) {
                        this.eof = true;
                        break block3;
                    }
                    Row row = this.iter.next();
                    this.cursor.setRow(row);
                } while ((arrayKey = this.toKey(this.cursor)).equals(this.tempArrKey));
                this.tempArrKey = arrayKey;
                this.nextRow = this.cursor;
            }
        }
    }
}

