/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.SortableStore;
import kd.bos.algo.env.ThreadContext;

public class ListStore
extends AbstractStore
implements SortableStore {
    private final Comparator<Row> comparator;
    private List<Row> list;
    private boolean sorted;

    public ListStore(RowMeta rowMeta, Comparator<Row> comparator) {
        super(rowMeta);
        this.comparator = comparator;
        ThreadContext.getCurrent().addStore(this);
        this.list = new ArrayList<Row>();
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        this.checkClosed();
        if (this.comparator != null && !this.sorted) {
            this.doSort();
        }
        return this.list.iterator();
    }

    @Override
    public void write(Iterator<Row> iter) {
        this.checkClosed();
        while (iter.hasNext()) {
            this.list.add(iter.next());
        }
    }

    @Override
    public void write(Row row) {
        this.list.add(((AbstractRow)row).persist());
    }

    @Override
    public void realClose() {
        this.list = null;
        ThreadContext.getCurrent().removeStore(this);
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public void doSort() {
        this.list.sort(this.comparator);
        this.sorted = true;
    }

    @Override
    public boolean isCopyable() {
        return true;
    }
}

