/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.StoreFactory;

public class StoreCopyWrapper
implements Store {
    private Store inner;

    public StoreCopyWrapper(Store inner) {
        this.inner = inner;
    }

    @Override
    public Iterator<Row> getRowIterator() {
        return this.inner.getRowIterator();
    }

    @Override
    public void write(Iterator<Row> iter) {
        this.inner.write(iter);
    }

    @Override
    public Store copy() {
        if (this.inner.isCopyable()) {
            return this.inner.copy();
        }
        Store newStore = StoreFactory.createDataSetBackStore(this.inner.getRowMeta());
        newStore.write(this.inner.getRowIterator());
        this.inner.close();
        this.inner = newStore;
        return newStore.copy();
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public RowMeta getRowMeta() {
        return this.inner.getRowMeta();
    }

    @Override
    public void write(Row row) {
        this.inner.write(row);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean isCopyable() {
        return true;
    }
}

