/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heaplimit;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.heaplimit.HeapLimitPolicy;
import kd.bos.algo.dataset.store.heaplimit.HeapStore;
import kd.bos.algo.dataset.store.sort.RowOrderComparator;

public class HeapOrderStore
extends HeapStore {
    private final RowOrderComparator comparator;
    private ArrayList<Row> list = new ArrayList();
    private boolean sorted;

    public HeapOrderStore(HeapLimitPolicy limitPolicy, RowOrderComparator comparator) {
        super(limitPolicy);
        this.comparator = comparator;
    }

    @Override
    public void addRow(Row row) {
        this.list.add(((AbstractRow)row).persist());
    }

    @Override
    public Iterator<Row> getResultIterator() {
        if (!this.sorted) {
            this.doSort();
            this.sorted = true;
        }
        return this.list.iterator();
    }

    private void doSort() {
        this.list.sort(this.comparator);
    }

    @Override
    public Iterator<Row> getOriginalIterator() {
        return this.list.iterator();
    }

    @Override
    public void close() {
        if (this.list != null) {
            super.close();
            this.list = null;
        }
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }
}

