/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heaplimit;

import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.heaplimit.HeapLimitPolicy;
import kd.bos.algo.dataset.store.heaplimit.HeapOrderStore;
import kd.bos.algo.dataset.store.heaplimit.HeapSequenceStore;
import kd.bos.algo.dataset.store.heaplimit.HeapStore;
import kd.bos.algo.dataset.store.heaplimit.MaxRowsLimitPolicy;
import kd.bos.algo.dataset.store.sort.RowOrderComparator;

public class HeapStoreFactory {
    private static MaxRowsLimitPolicy global = new MaxRowsLimitPolicy(AlgoConfiguration.HEAPCACHE_MAXROWS_GLOBAL.getInt());
    private static MaxRowsLimitPolicy sort = new MaxRowsLimitPolicy(AlgoConfiguration.HEAPCACHE_MAXROWS_SORT.getInt());
    private static MaxRowsLimitPolicy mergejoin = new MaxRowsLimitPolicy(AlgoConfiguration.HEAPCACHE_MAXROWS_MERGEJOIN.getInt());

    public static HeapLimitPolicy getGlobalPolicy() {
        global.setMaxRowsLimit(AlgoConfiguration.HEAPCACHE_MAXROWS_GLOBAL.getInt());
        return global;
    }

    public static HeapLimitPolicy getSortPolicy() {
        sort.setMaxRowsLimit(AlgoConfiguration.HEAPCACHE_MAXROWS_SORT.getInt());
        return sort;
    }

    public static HeapLimitPolicy getMergeJoinPolicy() {
        mergejoin.setMaxRowsLimit(AlgoConfiguration.HEAPCACHE_MAXROWS_MERGEJOIN.getInt());
        return mergejoin;
    }

    public static HeapStore createHeapSequenceStore() {
        return new HeapSequenceStore(HeapStoreFactory.getGlobalPolicy());
    }

    public static HeapStore createHeapMergeJoinStore() {
        return new HeapSequenceStore(HeapStoreFactory.getMergeJoinPolicy());
    }

    public static HeapStore createHeapOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        HeapLimitPolicy policy = HeapStoreFactory.getSortPolicy();
        return new HeapOrderStore(policy, new RowOrderComparator(rowMeta, orderItems));
    }
}

