/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heaplimit;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.heaplimit.HeapStore;
import kd.bos.algo.dataset.store.heaplimit.HeapStoreFactory;
import kd.bos.algo.dataset.store.spill.SpillWriter;
import kd.bos.algo.dataset.store.spill.SpillWriterFactory;
import kd.bos.algo.env.ThreadContext;

public class SequenceStore
extends AbstractStore {
    private static final long serialVersionUID = -566664619098919394L;
    private final boolean isStandalone;
    private HeapStore heapStore;
    private SpillWriter spill;

    public SequenceStore(RowMeta rowMeta) {
        this(rowMeta, null, false);
    }

    public SequenceStore(RowMeta rowMeta, boolean isStandalone) {
        this(rowMeta, null, isStandalone);
    }

    public SequenceStore(RowMeta rowMeta, HeapStore heapStore, boolean isStandalone) {
        super(rowMeta);
        this.isStandalone = isStandalone;
        if (!isStandalone) {
            ThreadContext.getCurrent().addStore(this);
        }
        if (heapStore == null) {
            heapStore = HeapStoreFactory.createHeapSequenceStore();
        }
        this.heapStore = heapStore;
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        if (this.spill == null) {
            return this.heapStore.getResultIterator();
        }
        if (this.heapStore.getRowCount() > 0) {
            return Iterators.concat(this.heapStore.getResultIterator(), this.spill.iterator());
        }
        return this.spill.iterator();
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.spill != null) {
            this.spill.writeRowIter(iter);
            return;
        }
        Row failedRow = this.heapStore.writeIterator(iter);
        if (failedRow != null) {
            iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)failedRow), iter);
            this.writeX(iter);
        }
    }

    private void createSpill() {
        if (this.spill == null) {
            this.spill = SpillWriterFactory.createSpill(this.rowMeta);
        }
    }

    public void writeX(Iterator<Row> iter) {
        this.createSpill();
        this.spill.writeRowIter(iter);
    }

    @Override
    public void realClose() {
        ThreadContext.getCurrent().removeStore(this);
        this.closed = true;
        if (this.heapStore != null) {
            this.heapStore.close();
        }
        if (this.spill != null) {
            this.spill.close();
        }
    }

    @Override
    public boolean isCopyable() {
        return true;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void write(Row row) {
        if (this.spill != null) {
            this.spill.writeRow(row);
            return;
        }
        if (!this.heapStore.write(row)) {
            this.createSpill();
            this.spill.writeRow(row);
        }
    }

    @Override
    public int size() {
        if (this.spill == null) {
            return this.heapStore.getRowCount();
        }
        return this.heapStore.getRowCount() + this.spill.size();
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }
}

