/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.heaplimit;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.AutoCloseIterator;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.heaplimit.HeapStore;
import kd.bos.algo.dataset.store.heaplimit.HeapStoreFactory;
import kd.bos.algo.dataset.store.sort.RowOrderComparator;
import kd.bos.algo.dataset.store.sort.TashaSortMerger;
import kd.bos.algo.env.ThreadContext;

public class TashaOrderStore
extends AbstractStore {
    private static final long serialVersionUID = 5437528116901485019L;
    private final OrderItem[] orderItems;
    private HeapStore heapStore;
    private TashaSortMerger merger;
    private boolean hasMergeEof;
    private boolean closed;

    public TashaOrderStore(RowMeta rowMeta, OrderItem[] orderItems) {
        super(rowMeta);
        this.orderItems = orderItems;
        ThreadContext.getCurrent().addStore(this);
        this.heapStore = HeapStoreFactory.createHeapOrderStore(rowMeta, orderItems);
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        if (this.merger == null) {
            return this.heapStore.getResultIterator();
        }
        try {
            this.ensureMergeEof();
            AutoCloseIterator iter = this.merger.getIterator();
            iter = new AutoCloseIterator(this, iter);
            return iter;
        }
        catch (InterruptedException e) {
            throw new AlgoException(e);
        }
    }

    private void ensureMergeEof() {
        if (!this.hasMergeEof) {
            this.merger.writeEof();
            this.hasMergeEof = true;
        }
    }

    @Override
    public void write(Iterator<Row> iter) {
        if (this.merger != null) {
            this.merger.writeInput(iter);
            return;
        }
        Row failedRow = this.heapStore.writeIterator(iter);
        if (failedRow != null) {
            if (this.heapStore.getRowCount() > 0) {
                Iterator<Row> originIter = this.heapStore.getOriginalIterator();
                iter = Iterators.concat(originIter, (Iterator)Iterators.singletonIterator((Object)failedRow), (Iterator)iter);
                this.heapStore.close();
            } else {
                iter = Iterators.concat((Iterator)Iterators.singletonIterator((Object)failedRow), iter);
            }
            this.writeX(this.rowMeta, iter);
        }
    }

    private void writeX(RowMeta rowMeta, Iterator<Row> iter) {
        try {
            this.merger = new TashaSortMerger(rowMeta, new RowOrderComparator(rowMeta, this.orderItems), AlgoConfiguration.SORTMERGE_BUFFER_NUMBER.getInt(), AlgoConfiguration.SORTMERGE_BUFFER_SIZE.getInt());
            this.merger.writeInput(iter);
        }
        catch (Exception e) {
            throw new AlgoException(e);
        }
    }

    @Override
    public void realClose() {
        if (!this.closed) {
            ThreadContext.getCurrent().removeStore(this);
            this.closed = true;
            if (this.heapStore != null) {
                this.heapStore.close();
            }
            if (this.merger != null) {
                this.merger.close();
            }
        }
    }

    @Override
    public boolean isCopyable() {
        return this.merger == null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void write(Row row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.checkClosed();
        if (this.merger == null) {
            return this.heapStore.getRowCount();
        }
        this.ensureMergeEof();
        return this.merger.getRowCount();
    }

    @Override
    public boolean isStandalone() {
        return false;
    }
}

