/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.Comparator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.Store;
import kd.bos.algo.dataset.store.mm.MemoryBufferStore;
import kd.bos.algo.dataset.store.mm.QuoteCalculator;
import kd.bos.algo.dataset.store.mm.SpillOnlyStore;
import kd.bos.algo.dataset.store.mm.Spiller;
import kd.bos.algo.dataset.store.mm.SpillerAsync;
import kd.bos.algo.dataset.store.mm.SpillerSync;
import kd.bos.algo.dataset.store.mm.StoreUnitAllocator;
import kd.bos.algo.dataset.store.mm.TransferableStore;
import kd.bos.algo.dataset.store.mm.allocator.StoreUnitAllocatorByQueue;

public class MMFactory {
    private static SpillerSync syncSpiller = new SpillerSync();
    private static SpillerAsync asyncSpiller = MMFactory.createAyncSpiller();
    private static QuoteCalculator quoteCalculator = new QuoteCalculator();
    private static StoreUnitAllocator allocator = new StoreUnitAllocatorByQueue();

    private static SpillerAsync createAyncSpiller() {
        int queueSize = AlgoConfiguration.MM_SPILL_ASYNC_QUEUESIZE.getInt();
        return new SpillerAsync(queueSize);
    }

    public static Spiller getSyncSpiller() {
        return syncSpiller;
    }

    public static Spiller getAsyncSpiller() {
        return asyncSpiller;
    }

    public static StoreUnitAllocator getMemAllocator() {
        return allocator;
    }

    public static Store createBackStore(RowMeta rowMeta) {
        if (quoteCalculator.isHuge(rowMeta)) {
            return new SpillOnlyStore(rowMeta, false);
        }
        return new TransferableStore(MMFactory.getMemAllocator(), quoteCalculator.getBackStoreMaxQuote(), rowMeta, false);
    }

    public static Store createStandaloneBackStore(RowMeta rowMeta) {
        if (quoteCalculator.isHuge(rowMeta)) {
            return new SpillOnlyStore(rowMeta, true);
        }
        int maxQuote = quoteCalculator.getStandaloneStoreMaxQuote();
        return new TransferableStore(MMFactory.getMemAllocator(), maxQuote, rowMeta, true);
    }

    public static MemoryBufferStore createMemeryBufferStore(RowMeta rowMeta, Comparator<Row> comparator) {
        return new MemoryBufferStore(MMFactory.getMemAllocator(), rowMeta, comparator);
    }

    public static QuoteCalculator getQuoteCalculator() {
        return quoteCalculator;
    }
}

