/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.dataset.store.HashMapStore;
import kd.bos.algo.dataset.store.mm.MMFactory;
import kd.bos.algo.dataset.store.mm.MMMapLimit;
import kd.bos.algo.dataset.store.mm.MemoryAllocateException;
import kd.bos.algo.dataset.store.mm.QuoteListener;
import kd.bos.algo.env.ThreadContext;

public class MMHashMapStore<K, V>
implements HashMapStore<K, V> {
    private HashMap<K, V> map = new HashMap();
    private final int oneQuoteRows;
    private final QuoteListener listener;
    private int size;
    private int quote;
    private boolean closed;

    public MMHashMapStore(int fieldCount, QuoteListener listener) {
        this.oneQuoteRows = MMFactory.getQuoteCalculator().calcOneQuoteRows(fieldCount);
        this.listener = listener;
        ThreadContext.getCurrent().addCloseable(this);
    }

    @Override
    public void put(K key, V value) {
        V old = this.map.putIfAbsent(key, value);
        if (old == null) {
            ++this.size;
            if (this.size % this.oneQuoteRows == 0) {
                ++this.quote;
                MMMapLimit.incr();
                try {
                    this.listener.quoteInc(1);
                }
                catch (MemoryAllocateException memoryAllocateException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.quote > 0) {
                this.listener.quoteDec(this.quote);
                MMMapLimit.decr(this.quote);
                this.quote = 0;
            }
            ThreadContext.getCurrent().removeCloseable(this);
        }
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

