/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.mm.MemoryAllocateException;
import kd.bos.algo.dataset.store.mm.QuoteListener;
import kd.bos.algo.dataset.store.mm.StoreUnit;

public class MemUnit
extends StoreUnit {
    private final int capacity;
    private final int oneQuoteRows;
    private final QuoteListener quoteListener;
    private ArrayList<Row> list = new ArrayList();
    private int size;
    private int quote;
    private AtomicBoolean released = new AtomicBoolean(false);

    public MemUnit(RowMeta rowMeta, int oneQuoteRows, QuoteListener quoteListener) {
        this(rowMeta, Integer.MAX_VALUE, oneQuoteRows, quoteListener);
    }

    public MemUnit(RowMeta rowMeta, int capacity, int oneQuoteRows, QuoteListener quoteListener) {
        super(rowMeta);
        this.capacity = capacity;
        this.oneQuoteRows = oneQuoteRows;
        this.quoteListener = quoteListener;
    }

    @Override
    public boolean addRow(Row row) {
        if (this.size >= this.capacity) {
            return false;
        }
        if (this.size % this.oneQuoteRows == 0) {
            ++this.quote;
            try {
                this.quoteListener.quoteInc(1);
            }
            catch (MemoryAllocateException e) {
                return false;
            }
        }
        this.list.add(((AbstractRow)row).persist());
        ++this.size;
        return true;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.list.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void release() {
        if (this.released.compareAndSet(false, true)) {
            this.list = null;
            this.quoteListener.quoteDec(this.quote);
        }
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getQuote() {
        return this.quote;
    }

    public void doSort(Comparator<Row> comparator) {
        if (this.list == null) {
            throw new AlgoException("Memory Unit released.");
        }
        this.list.sort(comparator);
    }
}

