/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.mm.allocator.AtomicQuoteValue;

public class QuoteCalculator {
    public int getGlobalMaxQuote() {
        return AlgoConfiguration.MM_LIMIT_GLOBALMAXCELLS.getInt() / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt();
    }

    public int getThreadMaxQuote() {
        return AlgoConfiguration.MM_LIMIT_THREADMAXCELLS.getInt() / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt();
    }

    public int getBackStoreMaxQuote() {
        return AlgoConfiguration.MM_LIMIT_THREADMAXCELLS.getInt() / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt() / 2;
    }

    public int getStandaloneStoreMaxQuote() {
        return AlgoConfiguration.MM_LIMIT_STANDALONEMAXCELLS.getInt() / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt() / 2;
    }

    public int calcQuote(int cells) {
        return cells / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt();
    }

    public int globalAvailable(AtomicQuoteValue globalQuote) {
        return AlgoConfiguration.MM_LIMIT_GLOBALMAXCELLS.getInt() / AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt() - globalQuote.getValue();
    }

    public int calcOneQuoteRows(int fieldCount) {
        int rows;
        if (fieldCount == 0) {
            fieldCount = 1;
        }
        if ((rows = AlgoConfiguration.MM_ALLOCATE_ONEQUOTECELLS.getInt() / fieldCount) < 1) {
            rows = 1;
        }
        return rows;
    }

    public int calcOneQuoteRows(RowMeta meta) {
        return this.calcOneQuoteRows(meta.getFieldCount());
    }

    public int calcBlockRows(RowMeta meta) {
        int fieldCount = meta.getFieldCount();
        if (fieldCount == 0) {
            fieldCount = 1;
        }
        return AlgoConfiguration.MM_ALLOCATE_ONEBLOCKCELLS.getInt() / fieldCount;
    }

    public boolean isHuge(RowMeta rowMeta) {
        return rowMeta.getFieldCount() >= AlgoConfiguration.MM_ALLOCATE_HUBEROWFIELDS.getInt();
    }
}

