/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.mm.SpillUnit;
import kd.bos.algo.env.ThreadContext;

public class SpillOnlyStore
extends AbstractStore {
    private final SpillUnit unit;
    private final boolean isStandalone;
    private int size;

    public SpillOnlyStore(RowMeta rowMeta, boolean isStandalone) {
        super(rowMeta);
        this.isStandalone = isStandalone;
        if (!isStandalone) {
            ThreadContext.getCurrent().addStore(this);
        }
        this.unit = new SpillUnit(rowMeta);
    }

    @Override
    public boolean isCopyable() {
        return true;
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        return this.unit.iterator();
    }

    @Override
    public void write(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.write(iter.next());
        }
    }

    @Override
    public void write(Row row) {
        this.unit.addRow(row);
        ++this.size;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void realClose() {
        ThreadContext.getCurrent().removeStore(this);
        this.unit.release();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }
}

