/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.store.mm.StoreUnit;
import kd.bos.algo.dataset.store.spill.SpillWriter;
import kd.bos.algo.dataset.store.spill.SpillWriterFactory;
import org.apache.log4j.Logger;

public class SpillUnit
extends StoreUnit {
    private static final Logger logger = Logger.getLogger(SpillUnit.class);
    private final SpillWriter writer;

    public SpillUnit(RowMeta rowMeta) {
        super(rowMeta);
        this.writer = SpillWriterFactory.createSpill(rowMeta);
    }

    @Override
    public boolean addRow(Row row) {
        this.writer.writeRow(((AbstractRow)row).persist());
        return true;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.writer.iterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void release() {
        try {
            this.writer.close();
        }
        catch (Throwable t) {
            logger.error((Object)"close writer error", t);
        }
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getQuote() {
        return 0;
    }
}

