/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.AbstractStore;
import kd.bos.algo.dataset.store.mm.StoreUnitAllocator;
import kd.bos.algo.dataset.store.mm.StoreUnitHolder;
import kd.bos.algo.env.ThreadContext;

class TransferableStore
extends AbstractStore {
    private final StoreUnitAllocator allocator;
    private final boolean isStandalone;
    private ArrayList<StoreUnitHolder> holders = new ArrayList();
    private StoreUnitHolder current;
    private int size = 0;
    private final int maxAllocateQuote;
    private int allocatedQuote;

    public TransferableStore(StoreUnitAllocator allocator, int maxAllocateQuote, RowMeta rowMeta, boolean isStandalone) {
        super(rowMeta);
        this.maxAllocateQuote = maxAllocateQuote;
        this.isStandalone = isStandalone;
        if (!isStandalone) {
            ThreadContext.getCurrent().addStore(this);
        }
        this.allocator = allocator;
        this.allocateAdvance();
    }

    private void allocateAdvance() {
        if (this.current != null) {
            this.current.finishAdd();
            this.allocatedQuote += this.current.getQuote();
        }
        this.current = this.allocatedQuote < this.maxAllocateQuote ? this.allocator.allocateTransferable(this.rowMeta, this.isStandalone) : this.allocator.allocateSpillOnly(this.rowMeta);
        this.holders.add(this.current);
    }

    @Override
    public Iterator<Row> getRowIterator0() {
        return Iterables.concat(this.holders).iterator();
    }

    @Override
    public void write(Iterator<Row> iter) {
        while (iter.hasNext()) {
            this.write(iter.next());
        }
    }

    @Override
    public void write(Row row) {
        if (!this.current.addRow(row)) {
            this.allocateAdvance();
            this.current.addRow(row);
        }
        ++this.size;
    }

    @Override
    public void realClose() {
        ThreadContext.getCurrent().removeStore(this);
        if (this.holders != null) {
            for (StoreUnitHolder holder : this.holders) {
                holder.close();
            }
            this.holders = null;
        }
        this.current = null;
    }

    @Override
    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public boolean isCopyable() {
        return true;
    }
}

