/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm.allocator;

import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

class CommonLinkedQueue<T>
implements Iterable<T> {
    private Node head;
    private Node last;
    private int size;

    CommonLinkedQueue() {
        this.last = this.head = new Node();
        this.size = 0;
    }

    public synchronized Node add(T t) {
        Node node = new Node(t);
        node.pre = this.last;
        this.last.next = node;
        this.last = node;
        ++this.size;
        return node;
    }

    public synchronized void remove(Node node) {
        if (node.removed) {
            return;
        }
        if (this.last == node) {
            this.last = node.pre;
        }
        node.pre.next = node.next;
        if (node.next != null) {
            node.next.pre = node.pre;
        }
        --this.size;
    }

    public synchronized int size() {
        return this.size;
    }

    @Override
    @NotNull
    public synchronized Iterator<T> iterator() {
        ArrayList list = new ArrayList();
        Node node = this.head.next;
        while (node != null) {
            list.add(node.t);
            node = node.next;
        }
        return list.iterator();
    }

    class Node {
        boolean removed;
        Node pre;
        Node next;
        T t;

        Node() {
        }

        Node(T t) {
            this.t = t;
        }

        public void released() {
            CommonLinkedQueue.this.remove(this);
        }
    }
}

