/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm.allocator;

import kd.bos.algo.dataset.store.mm.StoreUnitHolder;
import kd.bos.algo.dataset.store.mm.allocator.AtomicQuoteValue;
import kd.bos.algo.dataset.store.mm.allocator.StoreUnitHolderLinkedQueue;

class SimpleStoreUnitHolderLinkedQueue
implements StoreUnitHolderLinkedQueue {
    private final int maxQuote;
    private final AtomicQuoteValue currentQuote;
    private Node head;
    private Node last;
    private int size;

    SimpleStoreUnitHolderLinkedQueue(int maxQuote) {
        this.last = this.head = new Node();
        this.currentQuote = new AtomicQuoteValue();
        this.maxQuote = maxQuote;
    }

    int quoteAvailable() {
        return this.maxQuote - this.currentQuote.getValue();
    }

    public AtomicQuoteValue getCurrentQuote() {
        return this.currentQuote;
    }

    @Override
    public synchronized void add(StoreUnitHolder holder) {
        Node node = new Node(holder);
        node.pre = this.last;
        this.last.next = node;
        this.last = node;
        ++this.size;
    }

    public int size() {
        return this.size;
    }

    public synchronized StoreUnitHolder popAddFinished() {
        Node ret = this.head.next;
        while (ret != null && !ret.holder.isAddFinished()) {
            ret = ret.next;
        }
        if (ret == null) {
            return null;
        }
        this.detachNode(ret);
        return ret.holder;
    }

    private void detachNode(Node node) {
        if (node.detached) {
            return;
        }
        if (this.last == node) {
            this.last = node.pre;
        }
        node.pre.next = node.next;
        if (node.next != null) {
            node.next.pre = node.pre;
        }
        node.detached = true;
        --this.size;
    }

    private synchronized void remove(Node node) {
        if (node.removed) {
            return;
        }
        this.detachNode(node);
        node.removed = true;
    }

    public synchronized void release() {
        Node node = this.head.next;
        while (node != null) {
            node.holder.close();
            node = node.next;
        }
        this.head.next = null;
    }

    class Node
    implements StoreUnitHolder.Listener {
        public boolean detached;
        Node pre;
        Node next;
        StoreUnitHolder holder;
        private boolean removed;

        Node() {
        }

        Node(StoreUnitHolder holder) {
            this.holder = holder;
            holder.addListener(this);
        }

        @Override
        public void released() {
            SimpleStoreUnitHolderLinkedQueue.this.remove(this);
        }
    }
}

