/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.mm.allocator;

import java.util.function.Supplier;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.store.MultiValueMapStore;
import kd.bos.algo.dataset.store.mm.MMFactory;
import kd.bos.algo.dataset.store.mm.MMHashMapStore;
import kd.bos.algo.dataset.store.mm.MMMultiValueMapStore;
import kd.bos.algo.dataset.store.mm.MemUnit;
import kd.bos.algo.dataset.store.mm.MemoryAllocateException;
import kd.bos.algo.dataset.store.mm.QuoteCalculator;
import kd.bos.algo.dataset.store.mm.QuoteListener;
import kd.bos.algo.dataset.store.mm.SpillUnit;
import kd.bos.algo.dataset.store.mm.Spiller;
import kd.bos.algo.dataset.store.mm.StoreUnitAllocator;
import kd.bos.algo.dataset.store.mm.StoreUnitHolder;
import kd.bos.algo.dataset.store.mm.allocator.AtomicQuoteValue;
import kd.bos.algo.dataset.store.mm.allocator.CommonLinkedQueue;
import kd.bos.algo.dataset.store.mm.allocator.SharedStoreUnitHolderLinkedQueue;
import kd.bos.algo.dataset.store.mm.allocator.SimpleStoreUnitHolderLinkedQueue;
import kd.bos.util.ThreadLocals;
import org.apache.log4j.Logger;

public class StoreUnitAllocatorByQueue
implements StoreUnitAllocator {
    private final AtomicQuoteValue globalQuote = new AtomicQuoteValue();
    private final AtomicQuoteValue memoryOnlyQuote = new AtomicQuoteValue();
    private final AtomicQuoteValue bigQuote = new AtomicQuoteValue();
    private final SharedStoreUnitHolderLinkedQueue globalQueue;
    private final SharedStoreUnitHolderLinkedQueue memoryOnlyQueue;
    private final SharedStoreUnitHolderLinkedQueue bigQueue;
    private final CommonLinkedQueue<ThreadGod> threadGodQueue = new CommonLinkedQueue();
    private final QuoteCalculator quoteCalculator;
    private final Spiller syncSpiller = MMFactory.getSyncSpiller();
    private final Spiller asyncSpiller = MMFactory.getAsyncSpiller();
    private Logger logger = Logger.getLogger(this.getClass());
    private final ThreadLocal<ThreadGod> threadLocals = ThreadLocals.create(() -> this.createThreadGod());
    private Object spillLock = new Object();

    public StoreUnitAllocatorByQueue() {
        this.globalQueue = new SharedStoreUnitHolderLinkedQueue(this.globalQuote);
        this.memoryOnlyQueue = new SharedStoreUnitHolderLinkedQueue(this.globalQuote, this.memoryOnlyQuote);
        this.memoryOnlyQueue.addAdditionalQuoteHolder(() -> this.threadLocals.get().holderQueue.getCurrentQuote());
        this.bigQueue = new SharedStoreUnitHolderLinkedQueue(this.bigQuote);
        this.quoteCalculator = MMFactory.getQuoteCalculator();
    }

    @Override
    public StoreUnitHolder allocateTransferable(RowMeta rowMeta, boolean isStandalone) {
        ThreadGod tg = this.threadLocals.get();
        if (tg.holderQueue.quoteAvailable() >= 1) {
            if (this.globalQuoteAvailable() < 1) {
                this.spillGlobal(this.asyncSpiller, 1);
            }
        } else {
            this.spillThreadGod(this.asyncSpiller, 1, tg.holderQueue);
            return this.allocateSpillOnly(rowMeta);
        }
        int oneQuoteRows = this.quoteCalculator.calcOneQuoteRows(rowMeta);
        int capacity = this.quoteCalculator.calcBlockRows(rowMeta);
        MyQuoteListener listener = new MyQuoteListener(tg.holderQueue, () -> tg.holderQueue.getCurrentQuote(), () -> this.globalQuote);
        MemUnit unit = new MemUnit(rowMeta, capacity, oneQuoteRows, listener);
        StoreUnitHolder holder = new StoreUnitHolder(unit);
        if (!isStandalone) {
            tg.holderQueue.add(holder);
        }
        this.globalQueue.add(holder);
        return holder;
    }

    @Override
    public StoreUnitHolder allocateMemoryOnly(RowMeta rowMeta) {
        ThreadGod tg = this.threadLocals.get();
        boolean remainQuote = false;
        if (tg.holderQueue.quoteAvailable() >= 1) {
            if (this.globalQuoteAvailable() < 1) {
                this.spillGlobal(this.asyncSpiller, 1);
            }
        } else {
            this.spillThreadGod(this.asyncSpiller, 1, tg.holderQueue);
        }
        int oneQuoteRows = this.quoteCalculator.calcOneQuoteRows(rowMeta);
        MyQuoteListener listener = new MyQuoteListener(tg.holderQueue, () -> tg.holderQueue.getCurrentQuote(), () -> this.globalQuote, () -> this.memoryOnlyQuote);
        MemUnit unit = new MemUnit(rowMeta, oneQuoteRows, listener);
        StoreUnitHolder holder = new StoreUnitHolder(unit);
        this.memoryOnlyQueue.add(holder);
        return holder;
    }

    public <K, V> MMHashMapStore<K, V> allocateHashMapStore(int fieldCount) {
        ThreadGod tg = this.threadLocals.get();
        MyQuoteListener listener = new MyQuoteListener(tg.holderQueue, () -> tg.holderQueue.getCurrentQuote(), () -> this.globalQuote);
        return new MMHashMapStore(fieldCount, listener);
    }

    @Override
    public <K, V> MultiValueMapStore<K, V> allocateMultiValueMapStore(int fieldCount) {
        ThreadGod tg = this.threadLocals.get();
        MyQuoteListener listener = new MyQuoteListener(tg.holderQueue, () -> tg.holderQueue.getCurrentQuote(), () -> this.globalQuote);
        return new MMMultiValueMapStore(fieldCount, listener);
    }

    private int globalQuoteAvailable() {
        return this.quoteCalculator.globalAvailable(this.globalQuote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spillGlobal(Spiller spiller, int quote) {
        Object object = this.spillLock;
        synchronized (object) {
            StoreUnitHolder holder = null;
            while (quote > 0 && (holder = this.globalQueue.popAddFinished()) != null) {
                if (!holder.isMemory()) continue;
                quote -= holder.getQuote();
                if (spiller.write(holder)) continue;
                this.syncSpiller.write(holder);
            }
            return quote;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int spillThreadGod(Spiller spiller, int quote, SimpleStoreUnitHolderLinkedQueue threadHolderQueue) {
        Object object = this.spillLock;
        synchronized (object) {
            StoreUnitHolder holder = null;
            while (quote > 0 && (holder = threadHolderQueue.popAddFinished()) != null) {
                if (!holder.isMemory()) continue;
                quote -= holder.getQuote();
                if (spiller.write(holder)) continue;
                this.syncSpiller.write(holder);
            }
            return quote;
        }
    }

    @Override
    public StoreUnitHolder allocateSpillOnly(RowMeta rowMeta) {
        SpillUnit unit = new SpillUnit(rowMeta);
        StoreUnitHolder holder = new StoreUnitHolder(unit);
        return holder;
    }

    private StoreUnitHolder allocateSpill(RowMeta rowMeta, int size) {
        SpillUnit unit = new SpillUnit(rowMeta);
        StoreUnitHolder holder = new StoreUnitHolder(unit);
        return holder;
    }

    private ThreadGod createThreadGod() {
        return new ThreadGod();
    }

    @Override
    public String stats() {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("globalMaxQuote:").append(this.quoteCalculator.getGlobalMaxQuote()).append(",globalQuote:").append(this.globalQuote.getValue()).append(",memoryOnlyQuote:").append(this.memoryOnlyQuote.getValue()).append(",bigQuote:").append(this.bigQuote.getValue()).append(",globalQueue:").append(this.globalQueue.size()).append(",memoryOnlyQueue:").append(this.memoryOnlyQueue.size()).append(",bigQueue:").append(this.bigQueue.size()).append(",threadGods:").append(this.threadGodQueue.size()).append(",threadQuotes:");
            int total = 0;
            for (ThreadGod tg : this.threadGodQueue) {
                if (tg == null || tg.holderQueue == null || tg.holderQueue.getCurrentQuote() == null) continue;
                int v = tg.holderQueue.getCurrentQuote().getValue();
                sb.append(v).append(",");
                total += v;
            }
            sb.append("total:").append(total);
        }
        catch (Exception e) {
            this.logger.warn((Object)"get stats info error.", (Throwable)e);
        }
        return sb.toString();
    }

    class ThreadGod
    implements AutoCloseable {
        private final CommonLinkedQueue.Node node;
        private final SimpleStoreUnitHolderLinkedQueue holderQueue;

        public ThreadGod() {
            this.node = StoreUnitAllocatorByQueue.this.threadGodQueue.add(this);
            this.holderQueue = new SimpleStoreUnitHolderLinkedQueue(StoreUnitAllocatorByQueue.this.quoteCalculator.getThreadMaxQuote());
        }

        @Override
        public void close() {
            this.node.released();
            this.holderQueue.release();
        }
    }

    private class MyQuoteListener
    implements QuoteListener {
        private final SimpleStoreUnitHolderLinkedQueue threadHolderQueue;
        private final Supplier<AtomicQuoteValue>[] quoteValueSuppliers;

        public MyQuoteListener(SimpleStoreUnitHolderLinkedQueue threadHolderQueue, Supplier<AtomicQuoteValue> ... quoteValueSuppliers) {
            this.threadHolderQueue = threadHolderQueue;
            this.quoteValueSuppliers = quoteValueSuppliers;
        }

        @Override
        public void quoteInc(int quote) {
            for (Supplier<AtomicQuoteValue> quoteValue : this.quoteValueSuppliers) {
                quoteValue.get().inc(quote);
            }
            int threadQuoteAvailable = this.threadHolderQueue.quoteAvailable();
            if (threadQuoteAvailable >= quote) {
                if (StoreUnitAllocatorByQueue.this.globalQuoteAvailable() < quote) {
                    StoreUnitAllocatorByQueue.this.spillGlobal(StoreUnitAllocatorByQueue.this.asyncSpiller, quote);
                }
            } else {
                int remainQuote = StoreUnitAllocatorByQueue.this.spillThreadGod(StoreUnitAllocatorByQueue.this.asyncSpiller, quote, this.threadHolderQueue);
                if (remainQuote > 0) {
                    remainQuote = StoreUnitAllocatorByQueue.this.spillGlobal(StoreUnitAllocatorByQueue.this.asyncSpiller, quote);
                }
                if (remainQuote > 0) {
                    throw new MemoryAllocateException("Can't allocate memory unit.");
                }
            }
        }

        @Override
        public void quoteDec(int quote) {
            for (Supplier<AtomicQuoteValue> quoteValue : this.quoteValueSuppliers) {
                quoteValue.get().dec(quote);
            }
        }
    }
}

