/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.store.sort.PartialOrderPriorityQueue;

public class MergeIterator
implements Iterator<Row> {
    private final PartialOrderPriorityQueue<HeadStream> heap;
    private final Comparator<Row> comparator;

    public MergeIterator(List<Iterator<Row>> iterators, Comparator<Row> comparator) throws IOException {
        this.comparator = comparator;
        this.heap = new PartialOrderPriorityQueue<HeadStream>(new HeadStreamComparator(), iterators.size());
        for (Iterator<Row> iter : iterators) {
            this.heap.add(new HeadStream(() -> iter, true));
        }
    }

    public MergeIterator(List<Iterable<Row>> iterables, Comparator<Row> comparator, boolean autoClose) throws IOException {
        this.comparator = comparator;
        this.heap = new PartialOrderPriorityQueue<HeadStream>(new HeadStreamComparator(), iterables.size());
        for (Iterable<Row> iterable : iterables) {
            this.heap.add(new HeadStream(iterable, autoClose));
        }
    }

    @Override
    public boolean hasNext() {
        return this.heap.size() > 0;
    }

    @Override
    public Row next() {
        if (this.heap.size() > 0) {
            HeadStream top = this.heap.peek();
            Row result = top.getHead();
            if (!top.nextHead()) {
                this.heap.poll();
            } else {
                this.heap.adjustTop();
            }
            return result;
        }
        throw new NoSuchElementException();
    }

    private final class HeadStreamComparator
    implements Comparator<HeadStream> {
        private HeadStreamComparator() {
        }

        @Override
        public int compare(HeadStream o1, HeadStream o2) {
            return MergeIterator.this.comparator.compare(o1.head, o2.head);
        }
    }

    private static final class HeadStream {
        private final Iterable<Row> iterable;
        private final Iterator<Row> iterator;
        private Row head;
        private boolean autoClose;

        public HeadStream(Iterable<Row> iterable, boolean autoClose) throws IOException {
            this.iterable = iterable;
            this.iterator = iterable.iterator();
            this.autoClose = autoClose;
            if (!this.nextHead()) {
                throw new IllegalStateException();
            }
        }

        public Row getHead() {
            return this.head;
        }

        public boolean nextHead() {
            try {
                if (!this.iterator.hasNext()) {
                    if (this.autoClose && this.iterable instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)this.iterable)).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                this.head = this.iterator.next();
                return true;
            }
            catch (Throwable t) {
                throw new AlgoException(t);
            }
        }
    }
}

