/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.sort;

import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.OrderItem;
import kd.bos.algo.util.AlgoUtil;

public class RowOrderComparator
implements Comparator<Row> {
    private int len;
    private int[] orderIndexes;
    private boolean[] descs;
    private Collator[] collators;

    public RowOrderComparator(RowMeta rowMeta, OrderItem[] orderItems) {
        this.len = orderItems.length;
        this.orderIndexes = new int[this.len];
        this.descs = new boolean[this.len];
        this.collators = new Collator[this.len];
        for (int i = 0; i < this.len; ++i) {
            this.orderIndexes[i] = rowMeta.getFieldIndex(orderItems[i].expr);
            boolean bl = this.descs[i] = !orderItems[i].asc;
            if (orderItems[i].collcatorLocale == null) continue;
            this.collators[i] = Collator.getInstance(orderItems[i].collcatorLocale);
        }
    }

    public RowOrderComparator(int[] orderIndexes, boolean[] descs) {
        this(orderIndexes, descs, null);
    }

    public RowOrderComparator(int[] orderIndexes, boolean[] descs, Locale[] collatorLocales) {
        this.orderIndexes = orderIndexes;
        this.descs = descs;
        this.len = orderIndexes.length;
        this.collators = new Collator[this.len];
        if (collatorLocales != null) {
            for (int i = 0; i < this.len; ++i) {
                if (collatorLocales[i] == null) continue;
                this.collators[i] = Collator.getInstance(collatorLocales[i]);
            }
        }
    }

    @Override
    public int compare(Row row1, Row row2) {
        for (int i = 0; i < this.len; ++i) {
            int r;
            Object o1 = row1.get(this.orderIndexes[i]);
            Object o2 = row2.get(this.orderIndexes[i]);
            if (o1 == null) {
                if (o2 == null) continue;
                return this.descs[i] ? 1 : -1;
            }
            if (o2 == null) {
                return this.descs[i] ? -1 : 1;
            }
            if (o1 instanceof Number && o2 instanceof Number) {
                r = AlgoUtil.compareNumber((Number)o1, (Number)o2);
                if (r == 0) continue;
                return this.descs[i] ? -1 * r : r;
            }
            if (o1 instanceof Number && !(o2 instanceof Number)) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (!(o1 instanceof Number) && o2 instanceof Number) {
                throw new AlgoException("Value not compatible," + o1 + "(" + o1.getClass() + ")<>" + o2 + "(" + o2.getClass() + ")");
            }
            if (o1 instanceof Comparable) {
                if (this.collators[i] != null) {
                    if (!(o1 instanceof String) || !(o2 instanceof String)) {
                        throw new AlgoException("Order by collate field must by String.");
                    }
                    r = this.collators[i].compare(o1, o2);
                } else {
                    r = ((Comparable)o1).compareTo(o2);
                }
                if (r == 0) continue;
                return this.descs[i] ? -1 * r : r;
            }
            throw new AlgoException("Value not be comparable:" + o1);
        }
        return 0;
    }
}

