/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import java.io.IOException;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.serde.RawRowSerde;
import kd.bos.algo.util.memory.DataInputView;
import kd.bos.algo.util.memory.DataOutputView;

public class RowSerializer {
    private final RowMeta rowMeta;
    private final int arity;
    private boolean[] nullMask;

    public RowSerializer(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.arity = rowMeta.getFieldCount();
        this.nullMask = new boolean[this.arity];
    }

    public void serialize(Row row, DataOutputView target) throws IOException {
        AbstractRow ar = (AbstractRow)row;
        Object[] values = ar.values();
        try {
            RawRowSerde.writeNullMask(values.length, values, target);
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this.rowMeta.getFieldDataType(i).write(DataType.convertValue(this.rowMeta.getFieldDataType(i), values[i]), target);
            }
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
    }

    public Row deserialize(DataInputView source) throws IOException {
        try {
            RawRowSerde.readIntoNullMask(this.arity, source, this.nullMask);
            Object[] values = new Object[this.arity];
            for (int i = 0; i < values.length; ++i) {
                if (this.nullMask[i]) continue;
                values[i] = this.rowMeta.getFieldDataType(i).read(source);
            }
            return RowFactory.createRow(this.rowMeta, values, false);
        }
        catch (IOException e) {
            throw new AlgoException(e);
        }
    }

    public void close() {
    }
}

