/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.store.spill;

import kd.bos.algo.RowMeta;
import kd.bos.algo.config.AlgoConfiguration;
import kd.bos.algo.dataset.store.spill.AsynSpillWriter;
import kd.bos.algo.dataset.store.spill.LocalStorageSpillWriter;
import kd.bos.algo.dataset.store.spill.MemIO;
import kd.bos.algo.dataset.store.spill.MemIOFactory;
import kd.bos.algo.dataset.store.spill.SpillWriter;

public class SpillWriterFactory {
    public static SpillWriter createSpill(RowMeta rowMeta) {
        boolean min = AsynSpillWriter.getInstanceCount() > AlgoConfiguration.MEMORY_SPILL_ASYN_MAXINSTANCE.getInt();
        return SpillWriterFactory.createAsynSpill(rowMeta, min);
    }

    public static SpillWriter createLocalStorageSpill(RowMeta rowMeta) {
        return new LocalStorageSpillWriter(rowMeta);
    }

    public static SpillWriter createAsynSpill(RowMeta rowMeta) {
        return SpillWriterFactory.createAsynSpill(rowMeta, false);
    }

    public static SpillWriter createAsynSpill(RowMeta rowMeta, boolean min) {
        MemIO memIO = min ? MemIOFactory.createForMinSpillBuffer() : MemIOFactory.createForSpillBuffer();
        return new AsynSpillWriter(rowMeta, memIO.getMemoryManager(), memIO.getIoManager(), memIO.getMemoryManager().getTotalNumPages());
    }
}

