/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo.dataset.streamsource;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractDataSet;
import kd.bos.algo.dataset.InnerRowIterator;
import kd.bos.algo.dataset.RowFactory;
import kd.bos.algo.env.Environment;

public class ResultSetDataSet
extends AbstractDataSet {
    private ResultSet rs;

    public ResultSetDataSet(Environment env, ResultSet rs) {
        super("ResultSet", env);
        this.rs = rs;
        this.rowMeta = this.initRowMeta(rs);
    }

    public ResultSetDataSet(Environment env, ResultSet rs, RowMeta rowMeta) {
        super("ResultSet", env);
        this.rs = rs;
        this.rowMeta = rowMeta;
    }

    private RowMeta initRowMeta(ResultSet rs) {
        return RowMeta.fromResultSet(rs);
    }

    @Override
    protected RowMeta createTargetRowMeta() {
        return this.rowMeta;
    }

    @Override
    protected InnerRowIterator createIterator() {
        return new InnerRowIterator(){

            @Override
            public boolean _hasNext() {
                try {
                    return ResultSetDataSet.this.rs.next();
                }
                catch (SQLException e) {
                    throw new AlgoException(e);
                }
            }

            @Override
            public Row _next() {
                return RowFactory.createRow(ResultSetDataSet.this.rowMeta, ResultSetDataSet.this.rs);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void realClose() {
        if (this.rs != null) {
            try {
                Statement stmt = this.rs.getStatement();
                try {
                    this.rs.close();
                    this.rs = null;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

